/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.struct;

import hivemall.utils.lang.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class KeySortablePair<K extends Comparable<K>, V>
implements Comparable<KeySortablePair<K, V>> {
    @Nonnull
    private final K k;
    @Nullable
    private final V v;

    public KeySortablePair(@CheckForNull K k, @Nullable V v) {
        this.k = (Comparable)Preconditions.checkNotNull(k);
        this.v = v;
    }

    @Nonnull
    public K getKey() {
        return this.k;
    }

    @Nullable
    public V getValue() {
        return this.v;
    }

    @Override
    public int compareTo(KeySortablePair<K, V> o) {
        return this.k.compareTo(o.k);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.k.hashCode();
        result = 31 * result + (this.v == null ? 0 : this.v.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeySortablePair other = (KeySortablePair)obj;
        if (!this.k.equals(other.k)) {
            return false;
        }
        return !(this.v == null ? other.v != null : !this.v.equals(other.v));
    }

    public String toString() {
        return "k=" + this.k + ", v=" + this.v;
    }
}

