/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.struct;

import hivemall.utils.lang.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class ValueSortablePair<K, V extends Comparable<V>>
implements Comparable<ValueSortablePair<K, V>> {
    @Nonnull
    private final K k;
    @Nonnull
    private final V v;

    public ValueSortablePair(@CheckForNull K k, @Nonnull V v) {
        this.k = Preconditions.checkNotNull(k);
        this.v = (Comparable)Preconditions.checkNotNull(v);
    }

    @Nonnull
    public K getKey() {
        return this.k;
    }

    @Nonnull
    public V getValue() {
        return this.v;
    }

    @Override
    public int compareTo(ValueSortablePair<K, V> o) {
        return this.v.compareTo(o.v);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.k.hashCode();
        result = 31 * result + this.v.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueSortablePair other = (ValueSortablePair)obj;
        if (!this.k.equals(other.k)) {
            return false;
        }
        return this.v.equals(other.v);
    }

    public String toString() {
        return "k=" + this.k + ", v=" + this.v;
    }
}

