/*
 * Decompiled with CFR 0.152.
 */
package hivemall.xgboost;

import hivemall.UDTFWithOptions;
import hivemall.utils.collections.lists.FloatArrayList;
import hivemall.utils.collections.lists.IntArrayList;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.hadoop.WritableUtils;
import hivemall.utils.lang.Primitives;
import hivemall.xgboost.utils.NativeLibLoader;
import hivemall.xgboost.utils.XGBoostUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ml.dmlc.xgboost4j.LabeledPoint;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@Description(name="xgboost_batch_predict", value="_FUNC_(PRIMITIVE rowid, array<string|double> features, string model_id, array<string> pred_model [, string options]) - Returns a prediction result as (string rowid, array<double> predicted)", extended="select\n  rowid, \n  array_avg(predicted) as predicted,\n  avg(predicted[0]) as predicted0\nfrom (\n  select\n    xgboost_batch_predict(rowid, features, model_id, model) as (rowid, predicted)\n  from\n    xgb_model l\n    LEFT OUTER JOIN xgb_input r\n) t\ngroup by rowid;")
public final class XGBoostBatchPredictUDTF
extends UDTFWithOptions {
    private PrimitiveObjectInspector rowIdOI;
    private ListObjectInspector featureListOI;
    private boolean denseFeatures;
    @Nullable
    private PrimitiveObjectInspector featureElemOI;
    private StringObjectInspector modelIdOI;
    private StringObjectInspector modelOI;
    private transient Map<String, Booster> mapToModel;
    private transient Map<String, List<LabeledPointWithRowId>> rowBuffer;
    private int _batchSize;
    @Nonnull
    protected final transient Object[] _forwardObj = new Object[2];

    @Override
    protected Options getOptions() {
        Options opts = new Options();
        opts.addOption("batch_size", true, "Number of rows to predict together [default: 128]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        String rawArgs;
        int batchSize = 128;
        CommandLine cl = null;
        if (argOIs.length >= 5 && (batchSize = Primitives.parseInt((cl = this.parseOptions(rawArgs = HiveUtils.getConstString(argOIs, 4))).getOptionValue("batch_size"), batchSize)) < 1) {
            throw new UDFArgumentException("batch_size must be greater than 0: " + batchSize);
        }
        this._batchSize = batchSize;
        return cl;
    }

    public StructObjectInspector initialize(@Nonnull ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 4 && argOIs.length != 5) {
            this.showHelp("Invalid argment length=" + argOIs.length);
        }
        this.processOptions(argOIs);
        this.rowIdOI = HiveUtils.asPrimitiveObjectInspector(argOIs, 0);
        this.featureListOI = HiveUtils.asListOI(argOIs, 1);
        ObjectInspector elemOI = this.featureListOI.getListElementObjectInspector();
        if (HiveUtils.isNumberOI(elemOI)) {
            this.featureElemOI = HiveUtils.asDoubleCompatibleOI(elemOI);
            this.denseFeatures = true;
        } else if (HiveUtils.isStringOI(elemOI)) {
            this.denseFeatures = false;
        } else {
            throw new UDFArgumentException("Expected array<string|double> for the 2nd argment but got an unexpected features type: " + this.featureListOI.getTypeName());
        }
        this.modelIdOI = HiveUtils.asStringOI(argOIs, 2);
        this.modelOI = HiveUtils.asStringOI(argOIs, 3);
        return this.getReturnOI(this.rowIdOI);
    }

    @Nonnull
    protected StructObjectInspector getReturnOI(@Nonnull PrimitiveObjectInspector rowIdOI) {
        ArrayList<String> fieldNames = new ArrayList<String>(2);
        ArrayList<Object> fieldOIs = new ArrayList<Object>(2);
        fieldNames.add("rowid");
        fieldOIs.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)rowIdOI.getPrimitiveCategory()));
        fieldNames.add("predicted");
        fieldOIs.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableFloatObjectInspector));
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        List<LabeledPointWithRowId> rowBatch;
        if (this.mapToModel == null) {
            this.mapToModel = new HashMap<String, Booster>();
            this.rowBuffer = new HashMap<String, List<LabeledPointWithRowId>>();
        }
        if (args[1] == null) {
            return;
        }
        String modelId = PrimitiveObjectInspectorUtils.getString((Object)XGBoostBatchPredictUDTF.nonNullArgument(args, 2), (PrimitiveObjectInspector)this.modelIdOI);
        Booster model = this.mapToModel.get(modelId);
        if (model == null) {
            Text arg3 = this.modelOI.getPrimitiveWritableObject(XGBoostBatchPredictUDTF.nonNullArgument(args, 3));
            model = XGBoostUtils.deserializeBooster(arg3);
            this.mapToModel.put(modelId, model);
        }
        if ((rowBatch = this.rowBuffer.get(modelId)) == null) {
            rowBatch = new ArrayList<LabeledPointWithRowId>(this._batchSize);
            this.rowBuffer.put(modelId, rowBatch);
        }
        LabeledPointWithRowId row = this.parseRow(args);
        rowBatch.add(row);
        if (rowBatch.size() >= this._batchSize) {
            this.predictAndFlush(model, rowBatch);
        }
    }

    @Nonnull
    private LabeledPointWithRowId parseRow(@Nonnull Object[] args) throws UDFArgumentException {
        Writable rowId = HiveUtils.copyToWritable(XGBoostBatchPredictUDTF.nonNullArgument(args, 0), this.rowIdOI);
        Object arg1 = args[1];
        if (this.denseFeatures) {
            return XGBoostBatchPredictUDTF.parseDenseFeatures(rowId, arg1, this.featureListOI, this.featureElemOI);
        }
        return XGBoostBatchPredictUDTF.parseSparseFeatures(rowId, arg1, this.featureListOI);
    }

    @Nonnull
    private static LabeledPointWithRowId parseDenseFeatures(@Nonnull Writable rowId, @Nonnull Object argObj, @Nonnull ListObjectInspector featureListOI, @Nonnull PrimitiveObjectInspector featureElemOI) throws UDFArgumentException {
        int size = featureListOI.getListLength(argObj);
        float[] values = new float[size];
        for (int i = 0; i < size; ++i) {
            float v;
            Object o = featureListOI.getListElement(argObj, i);
            values[i] = o == null ? Float.NaN : (v = PrimitiveObjectInspectorUtils.getFloat((Object)o, (PrimitiveObjectInspector)featureElemOI));
        }
        return new LabeledPointWithRowId(rowId, 0.0f, null, values);
    }

    @Nonnull
    private static LabeledPointWithRowId parseSparseFeatures(@Nonnull Writable rowId, @Nonnull Object argObj, @Nonnull ListObjectInspector featureListOI) throws UDFArgumentException {
        int size = featureListOI.getListLength(argObj);
        IntArrayList indices = new IntArrayList(size);
        FloatArrayList values = new FloatArrayList(size);
        for (int i = 0; i < size; ++i) {
            float value;
            int index;
            Object f = featureListOI.getListElement(argObj, i);
            if (f == null) continue;
            String str = f.toString();
            int pos = str.indexOf(58);
            if (pos < 1) {
                throw new UDFArgumentException("Invalid feature format: " + str);
            }
            try {
                index = Integer.parseInt(str.substring(0, pos));
                value = Float.parseFloat(str.substring(pos + 1));
            }
            catch (NumberFormatException e) {
                throw new UDFArgumentException("Failed to parse a feature value: " + str);
            }
            indices.add(index);
            values.add(value);
        }
        return new LabeledPointWithRowId(rowId, 0.0f, indices.toArray(), values.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HiveException {
        for (Map.Entry<String, List<LabeledPointWithRowId>> e : this.rowBuffer.entrySet()) {
            String modelId = e.getKey();
            List<LabeledPointWithRowId> rowBatch = e.getValue();
            if (rowBatch.isEmpty()) continue;
            Booster model = Objects.requireNonNull(this.mapToModel.get(modelId));
            try {
                this.predictAndFlush(model, rowBatch);
            }
            finally {
                XGBoostUtils.close(model);
            }
        }
        this.rowBuffer = null;
        this.mapToModel = null;
    }

    private void predictAndFlush(@Nonnull Booster model, @Nonnull List<LabeledPointWithRowId> rowBatch) throws HiveException {
        float[][] predicted;
        DMatrix testData = null;
        try {
            testData = XGBoostUtils.createDMatrix(rowBatch);
            predicted = model.predict(testData);
        }
        catch (XGBoostError e) {
            throw new HiveException("Exception caused at prediction", (Throwable)e);
        }
        finally {
            XGBoostUtils.close(testData);
        }
        this.forwardPredicted(rowBatch, predicted);
        rowBatch.clear();
    }

    private void forwardPredicted(@Nonnull List<LabeledPointWithRowId> rowBatch, @Nonnull float[][] predicted) throws HiveException {
        if (rowBatch.size() != predicted.length) {
            throw new HiveException(String.format("buf.size() = %d but predicted.length = %d", rowBatch.size(), predicted.length));
        }
        if (predicted.length == 0) {
            return;
        }
        int ncols = predicted[0].length;
        List<FloatWritable> list = WritableUtils.newFloatList(ncols);
        Object[] forwardObj = this._forwardObj;
        forwardObj[1] = list;
        for (int i = 0; i < predicted.length; ++i) {
            Writable rowId = Objects.requireNonNull(rowBatch.get(i)).getRowId();
            forwardObj[0] = rowId;
            WritableUtils.setValues(predicted[i], list);
            this.forward(forwardObj);
        }
    }

    static {
        NativeLibLoader.initXGBoost();
    }

    public static final class LabeledPointWithRowId
    extends LabeledPoint {
        private static final long serialVersionUID = -7150841669515184648L;
        @Nonnull
        final Writable rowId;

        LabeledPointWithRowId(@Nonnull Writable rowId, float label, @Nullable int[] indices, @Nonnull float[] values) {
            super(label, indices, values);
            this.rowId = rowId;
        }

        @Nonnull
        public Writable getRowId() {
            return this.rowId;
        }
    }
}

