/*
 * Decompiled with CFR 0.152.
 */
package hivemall.xgboost.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NativeLibLoader {
    private static final Log logger = LogFactory.getLog(NativeLibLoader.class);
    private static final String keyUserDefinedLib = "hivemall.xgboost.lib";
    private static final String libPath = "/lib/";
    private static boolean initialized = false;

    public static synchronized void initXGBoost() {
        if (!initialized) {
            String userDefinedLib = System.getProperty(keyUserDefinedLib);
            if (userDefinedLib == null) {
                NativeLibLoader.tryLoadNativeLibFromResource("xgboost4j");
            } else {
                NativeLibLoader.tryLoadNativeLib(userDefinedLib);
            }
            initialized = true;
        }
    }

    private static boolean hasResource(String path) {
        return NativeLibLoader.class.getResource(path) != null;
    }

    @Nonnull
    private static String getOSName() {
        return System.getProperty("os.name");
    }

    private static void tryLoadNativeLibFromResource(String libName) {
        String resolvedLibName = System.mapLibraryName(libName);
        if (!NativeLibLoader.hasResource(libPath + resolvedLibName)) {
            if (!NativeLibLoader.getOSName().equals("Mac")) {
                return;
            }
            resolvedLibName = "lib" + libName + ".jnilib";
            if (NativeLibLoader.hasResource(libPath + resolvedLibName)) {
                return;
            }
        }
        try {
            File tempFile = NativeLibLoader.createTempFileFromResource(resolvedLibName, NativeLibLoader.class.getResourceAsStream(libPath + resolvedLibName));
            logger.info((Object)("Copyed the native library in JAR as " + tempFile.getAbsolutePath()));
            NativeLibLoader.addLibraryPath(tempFile.getParent());
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
    }

    private static void tryLoadNativeLib(String userDefinedLib) {
        File userDefinedLibFile = new File(userDefinedLib);
        if (!userDefinedLibFile.exists()) {
            logger.warn((Object)(userDefinedLib + " not found"));
        } else {
            try {
                File tempFile = NativeLibLoader.createTempFileFromResource(userDefinedLibFile.getName(), new FileInputStream(userDefinedLibFile.getAbsolutePath()));
                logger.info((Object)("Copyed the user-defined native library as " + tempFile.getAbsolutePath()));
                NativeLibLoader.addLibraryPath(tempFile.getParent());
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
        }
    }

    @Nonnull
    private static String getPrefix(@Nonnull String fileName) {
        int point = fileName.lastIndexOf(".");
        if (point != -1) {
            return fileName.substring(0, point);
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File createTempFileFromResource(String libName, InputStream is) throws IOException, IllegalArgumentException {
        boolean created;
        String uuid = UUID.randomUUID().toString();
        File tempFolder = new File(System.getProperty("java.io.tmpdir"), String.format("%s-%s", NativeLibLoader.getPrefix(libName), uuid));
        if (!tempFolder.exists() && !(created = tempFolder.mkdirs())) {
            throw new IOException("Failed to create a temporary folder for the native lib");
        }
        byte[] buffer = new byte[8192];
        File extractedLibFile = new File(tempFolder.getAbsolutePath(), libName);
        FileOutputStream os = new FileOutputStream(extractedLibFile);
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
        return extractedLibFile;
    }

    private static void addLibraryPath(String libPath) throws IOException {
        try {
            String[] paths;
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            for (String path : paths = (String[])field.get(null)) {
                if (!libPath.equals(path)) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = libPath;
            field.set(null, tmp);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage());
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            logger.error((Object)e.getMessage());
            throw new IOException("Failed to get field handle to set library path");
        }
    }
}

