/*
 * Decompiled with CFR 0.152.
 */
package hivemall.xgboost.utils;

import hivemall.utils.collections.lists.FloatArrayList;
import hivemall.utils.collections.lists.LongArrayList;
import hivemall.xgboost.utils.DMatrixBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.utils.collections.lists.IntArrayList;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;

public final class SparseDMatrixBuilder
extends DMatrixBuilder {
    private final boolean sortRequired;
    @Nonnull
    private final LongArrayList rowPointers;
    @Nonnull
    private final IntArrayList columnIndices;
    @Nonnull
    private final FloatArrayList values;
    @Nonnull
    private final List<ColValue> colCache;
    private int maxNumColumns;

    public SparseDMatrixBuilder(@Nonnegative int initSize) {
        this(initSize, true);
    }

    public SparseDMatrixBuilder(@Nonnegative int initSize, boolean sortRequired) {
        this.sortRequired = sortRequired;
        this.rowPointers = new LongArrayList(initSize + 1);
        this.rowPointers.add(0L);
        this.columnIndices = new IntArrayList(initSize);
        this.values = new FloatArrayList(initSize);
        this.colCache = new ArrayList<ColValue>(32);
        this.maxNumColumns = 0;
    }

    @Override
    @Nonnull
    public SparseDMatrixBuilder nextRow() {
        if (this.sortRequired) {
            Collections.sort(this.colCache);
        }
        for (ColValue e : this.colCache) {
            this.columnIndices.add(e.col);
            this.values.add(e.value);
        }
        this.colCache.clear();
        int ptr = this.values.size();
        this.rowPointers.add(ptr);
        return this;
    }

    @Override
    @Nonnull
    public SparseDMatrixBuilder nextColumn(@Nonnegative int col, float value) {
        SparseDMatrixBuilder.checkColIndex(col);
        this.maxNumColumns = Math.max(col + 1, this.maxNumColumns);
        if ((double)value == 0.0) {
            return this;
        }
        this.colCache.add(new ColValue(col, value));
        return this;
    }

    @Override
    @Nonnull
    public DMatrix buildMatrix(@Nonnull float[] labels) throws XGBoostError {
        DMatrix matrix = new DMatrix(this.rowPointers.toArray(true), this.columnIndices.toArray(true), this.values.toArray(true), DMatrix.SparseType.CSR, this.maxNumColumns);
        matrix.setLabel(labels);
        return matrix;
    }

    private static final class ColValue
    implements Comparable<ColValue> {
        final int col;
        final float value;

        ColValue(int col, float value) {
            this.col = col;
            this.value = value;
        }

        @Override
        public int compareTo(ColValue o) {
            return Integer.compare(this.col, o.col);
        }

        public String toString() {
            return "[column=" + this.col + ", value=" + this.value + ']';
        }
    }
}

