/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.Matrix;
import matrix4j.vector.SparseVector;
import matrix4j.vector.Vector;
import matrix4j.vector.VectorProcedure;

public abstract class AbstractMatrix
implements Matrix {
    @Override
    public double[] row() {
        int cols = this.numColumns();
        return new double[cols];
    }

    @Override
    public Vector rowVector() {
        return new SparseVector();
    }

    @Override
    public final double get(@Nonnegative int row, @Nonnegative int col) {
        return this.get(row, col, 0.0);
    }

    protected static final void checkRowIndex(int row, int numRows) {
        if (row < 0 || row >= numRows) {
            throw new IndexOutOfBoundsException("Row index " + row + " out of bounds " + numRows);
        }
    }

    protected static final void checkColIndex(int col, int numColumns) {
        if (col < 0 || col >= numColumns) {
            throw new IndexOutOfBoundsException("Col index " + col + " out of bounds " + numColumns);
        }
    }

    protected static final void checkIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Invalid index " + index);
        }
    }

    protected static final void checkIndex(int row, int col) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("Invalid row index " + row);
        }
        if (col < 0) {
            throw new IndexOutOfBoundsException("Invalid col index " + col);
        }
    }

    protected static final void checkIndex(int row, int col, int numRows, int numColumns) {
        if (row < 0 || row >= numRows) {
            throw new IndexOutOfBoundsException("Row index " + row + " out of bounds " + numRows);
        }
        if (col < 0 || col >= numColumns) {
            throw new IndexOutOfBoundsException("Col index " + col + " out of bounds " + numColumns);
        }
    }

    @Override
    public void eachInRow(int row, @Nonnull VectorProcedure procedure) {
        this.eachInRow(row, procedure, true);
    }

    @Override
    public void eachInColumn(int col, @Nonnull VectorProcedure procedure) {
        this.eachInColumn(col, procedure, true);
    }

    @Override
    public void eachNonNullInRow(int row, @Nonnull VectorProcedure procedure) {
        this.eachInRow(row, procedure, false);
    }

    @Override
    public void eachNonNullInColumn(int col, @Nonnull VectorProcedure procedure) {
        this.eachInColumn(col, procedure, false);
    }

    @Override
    public void eachNonZeroCell(VectorProcedure procedure) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public String toString() {
        int printSize = 7;
        StringBuilder buf = new StringBuilder();
        int rows = this.numRows();
        int cols = this.numColumns();
        String newline = cols > 7 ? "...\n" : "\n";
        int maxRows = Math.min(7, rows);
        for (int i = 0; i < maxRows; ++i) {
            int maxCols = Math.min(7, cols);
            for (int j = 0; j < maxCols; ++j) {
                buf.append(String.format("%8.4f  ", this.get(i, j)));
            }
            buf.append(newline);
        }
        if (rows > 7) {
            buf.append("  ...\n");
        }
        return buf.toString();
    }
}

