/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import matrix4j.matrix.ColumnMajorMatrix;
import matrix4j.matrix.RowMajorMatrix;
import matrix4j.matrix.builders.MatrixBuilder;
import matrix4j.vector.Vector;
import matrix4j.vector.VectorProcedure;

@NotThreadSafe
public interface Matrix {
    public boolean isSparse();

    public boolean isRowMajorMatrix();

    public boolean isColumnMajorMatrix();

    public boolean readOnly();

    public boolean swappable();

    public int nnz();

    @Nonnegative
    public int numRows();

    @Nonnegative
    public int numColumns();

    @Nonnegative
    public int numColumns(@Nonnegative int var1);

    @Nonnull
    public double[] row();

    @Nonnull
    public Vector rowVector();

    @Nonnull
    public double[] getRow(@Nonnegative int var1);

    @Nonnull
    public double[] getRow(@Nonnegative int var1, @Nonnull double[] var2);

    public void getRow(@Nonnegative int var1, @Nonnull Vector var2);

    public double get(@Nonnegative int var1, @Nonnegative int var2);

    public double get(@Nonnegative int var1, @Nonnegative int var2, double var3);

    public void set(@Nonnegative int var1, @Nonnegative int var2, double var3);

    public double getAndSet(@Nonnegative int var1, @Nonnegative int var2, double var3);

    public void swap(@Nonnegative int var1, @Nonnegative int var2);

    public void eachInRow(@Nonnegative int var1, @Nonnull VectorProcedure var2);

    public void eachInRow(@Nonnegative int var1, @Nonnull VectorProcedure var2, boolean var3);

    public void eachNonNullInRow(@Nonnegative int var1, @Nonnull VectorProcedure var2);

    public void eachNonZeroInRow(@Nonnegative int var1, @Nonnull VectorProcedure var2);

    public void eachColumnIndexInRow(@Nonnegative int var1, @Nonnull VectorProcedure var2);

    public void eachInColumn(@Nonnegative int var1, @Nonnull VectorProcedure var2);

    public void eachInColumn(@Nonnegative int var1, @Nonnull VectorProcedure var2, boolean var3);

    public void eachNonNullInColumn(@Nonnegative int var1, @Nonnull VectorProcedure var2);

    public void eachNonZeroInColumn(@Nonnegative int var1, @Nonnull VectorProcedure var2);

    public void eachNonZeroCell(@Nonnull VectorProcedure var1);

    @Nonnull
    public RowMajorMatrix toRowMajorMatrix();

    @Nonnull
    public ColumnMajorMatrix toColumnMajorMatrix();

    @Nonnull
    public MatrixBuilder builder();
}

