/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix;

import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.Matrix;
import matrix4j.matrix.builders.MatrixBuilder;
import matrix4j.matrix.ints.IntMatrix;
import matrix4j.matrix.sparse.CSCMatrix;
import matrix4j.matrix.sparse.CSRMatrix;
import matrix4j.matrix.sparse.floats.CSCFloatMatrix;
import matrix4j.matrix.sparse.floats.CSRFloatMatrix;
import matrix4j.utils.lang.Preconditions;
import matrix4j.utils.lang.mutable.MutableInt;
import matrix4j.vector.VectorProcedure;

public final class MatrixUtils {
    private MatrixUtils() {
    }

    @Nonnull
    public static Matrix shuffle(@Nonnull Matrix m, @Nonnull int[] indices) {
        Preconditions.checkArgument(m.numRows() <= indices.length, "m.numRow() `" + m.numRows() + "` MUST be equals to or less than |swapIndices| `" + indices.length + "`");
        final MatrixBuilder builder = m.builder();
        VectorProcedure proc = new VectorProcedure(){

            @Override
            public void apply(int col, double value) {
                builder.nextColumn(col, value);
            }
        };
        for (int i = 0; i < indices.length; ++i) {
            int idx = indices[i];
            m.eachNonNullInRow(idx, proc);
            builder.nextRow();
        }
        return builder.buildMatrix();
    }

    public static int whichMax(@Nonnull IntMatrix matrix, @Nonnegative int row) {
        final MutableInt m = new MutableInt(Integer.MIN_VALUE);
        final MutableInt which = new MutableInt(-1);
        matrix.eachInRow(row, new VectorProcedure(){

            @Override
            public void apply(int i, int value) {
                if (value > m.getValue()) {
                    m.setValue(value);
                    which.setValue(i);
                }
            }
        }, false);
        return which.getValue();
    }

    @Nonnull
    public static CSRMatrix coo2csr(@Nonnull int[] rows, @Nonnull int[] cols, @Nonnull double[] data, @Nonnegative int numRows, @Nonnegative int numCols, boolean sortColumns) {
        int nnz = data.length;
        Preconditions.checkArgument(rows.length == nnz);
        Preconditions.checkArgument(cols.length == nnz);
        int[] rowPointers = new int[numRows + 1];
        int[] colIndices = new int[nnz];
        double[] values = new double[nnz];
        MatrixUtils.coo2csr(rows, cols, data, rowPointers, colIndices, values, numRows, numCols, nnz);
        if (sortColumns) {
            MatrixUtils.sortIndices(rowPointers, colIndices, values);
        }
        return new CSRMatrix(rowPointers, colIndices, values, numCols);
    }

    @Nonnull
    public static CSRFloatMatrix coo2csr(@Nonnull int[] rows, @Nonnull int[] cols, @Nonnull float[] data, @Nonnegative int numRows, @Nonnegative int numCols, boolean sortColumns) {
        int nnz = data.length;
        Preconditions.checkArgument(rows.length == nnz);
        Preconditions.checkArgument(cols.length == nnz);
        int[] rowPointers = new int[numRows + 1];
        int[] colIndices = new int[nnz];
        float[] values = new float[nnz];
        MatrixUtils.coo2csr(rows, cols, data, rowPointers, colIndices, values, numRows, numCols, nnz);
        if (sortColumns) {
            MatrixUtils.sortIndices(rowPointers, colIndices, values);
        }
        return new CSRFloatMatrix(rowPointers, colIndices, values, numCols);
    }

    @Nonnull
    public static CSCMatrix coo2csc(@Nonnull int[] rows, @Nonnull int[] cols, @Nonnull double[] data, @Nonnegative int numRows, @Nonnegative int numCols, boolean sortRows) {
        int nnz = data.length;
        Preconditions.checkArgument(rows.length == nnz);
        Preconditions.checkArgument(cols.length == nnz);
        int[] columnPointers = new int[numCols + 1];
        int[] rowIndices = new int[nnz];
        double[] values = new double[nnz];
        MatrixUtils.coo2csr(cols, rows, data, columnPointers, rowIndices, values, numCols, numRows, nnz);
        if (sortRows) {
            MatrixUtils.sortIndices(columnPointers, rowIndices, values);
        }
        return new CSCMatrix(columnPointers, rowIndices, values, numRows, numCols);
    }

    @Nonnull
    public static CSCFloatMatrix coo2csc(@Nonnull int[] rows, @Nonnull int[] cols, @Nonnull float[] data, @Nonnegative int numRows, @Nonnegative int numCols, boolean sortRows) {
        int nnz = data.length;
        Preconditions.checkArgument(rows.length == nnz);
        Preconditions.checkArgument(cols.length == nnz);
        int[] columnPointers = new int[numCols + 1];
        int[] rowIndices = new int[nnz];
        float[] values = new float[nnz];
        MatrixUtils.coo2csr(cols, rows, data, columnPointers, rowIndices, values, numCols, numRows, nnz);
        if (sortRows) {
            MatrixUtils.sortIndices(columnPointers, rowIndices, values);
        }
        return new CSCFloatMatrix(columnPointers, rowIndices, values, numRows, numCols);
    }

    private static void coo2csr(@Nonnull int[] rows, @Nonnull int[] cols, @Nonnull double[] data, @Nonnull int[] rowPointers, @Nonnull int[] colIndices, @Nonnull double[] values, @Nonnegative int numRows, @Nonnegative int numCols, int nnz) {
        int i;
        int n;
        for (n = 0; n < nnz; ++n) {
            int n2 = rows[n];
            rowPointers[n2] = rowPointers[n2] + 1;
        }
        int sum = 0;
        for (i = 0; i < numRows; ++i) {
            int curr = rowPointers[i];
            rowPointers[i] = sum;
            sum += curr;
        }
        rowPointers[numRows] = nnz;
        for (n = 0; n < nnz; ++n) {
            int row = rows[n];
            int dst = rowPointers[row];
            colIndices[dst] = cols[n];
            values[dst] = data[n];
            int n3 = row;
            rowPointers[n3] = rowPointers[n3] + 1;
        }
        int last = 0;
        for (i = 0; i <= numRows; ++i) {
            int tmp = rowPointers[i];
            rowPointers[i] = last;
            last = tmp;
        }
    }

    private static void coo2csr(@Nonnull int[] rows, @Nonnull int[] cols, @Nonnull float[] data, @Nonnull int[] rowPointers, @Nonnull int[] colIndices, @Nonnull float[] values, @Nonnegative int numRows, @Nonnegative int numCols, int nnz) {
        int i;
        int n;
        for (n = 0; n < nnz; ++n) {
            int n2 = rows[n];
            rowPointers[n2] = rowPointers[n2] + 1;
        }
        int sum = 0;
        for (i = 0; i < numRows; ++i) {
            int curr = rowPointers[i];
            rowPointers[i] = sum;
            sum += curr;
        }
        rowPointers[numRows] = nnz;
        for (n = 0; n < nnz; ++n) {
            int row = rows[n];
            int dst = rowPointers[row];
            colIndices[dst] = cols[n];
            values[dst] = data[n];
            int n3 = row;
            rowPointers[n3] = rowPointers[n3] + 1;
        }
        int last = 0;
        for (i = 0; i <= numRows; ++i) {
            int tmp = rowPointers[i];
            rowPointers[i] = last;
            last = tmp;
        }
    }

    private static void sortIndices(@Nonnull int[] majorAxisPointers, @Nonnull int[] minorAxisIndices, @Nonnull double[] values) {
        int numRows = majorAxisPointers.length - 1;
        if (numRows <= 1) {
            return;
        }
        for (int i = 0; i < numRows; ++i) {
            int rowEnd = majorAxisPointers[i + 1];
            int rowStart = majorAxisPointers[i];
            int numCols = rowEnd - rowStart;
            if (numCols == 0) continue;
            if (numCols < 0) {
                throw new IllegalArgumentException("numCols SHOULD be greater than zero. numCols = rowEnd - rowStart = " + rowEnd + " - " + rowStart + " = " + numCols + " at i=" + i);
            }
            IntDoublePair[] pairs = new IntDoublePair[numCols];
            int jj = rowStart;
            int n = 0;
            while (jj < rowEnd) {
                pairs[n] = new IntDoublePair(minorAxisIndices[jj], values[jj]);
                ++jj;
                ++n;
            }
            Arrays.sort(pairs, new Comparator<IntDoublePair>(){

                @Override
                public int compare(IntDoublePair x, IntDoublePair y) {
                    return Integer.compare(x.key, y.key);
                }
            });
            jj = rowStart;
            n = 0;
            while (jj < rowEnd) {
                IntDoublePair tmp = pairs[n];
                minorAxisIndices[jj] = tmp.key;
                values[jj] = tmp.value;
                ++jj;
                ++n;
            }
        }
    }

    private static void sortIndices(@Nonnull int[] majorAxisPointers, @Nonnull int[] minorAxisIndices, @Nonnull float[] values) {
        int numRows = majorAxisPointers.length - 1;
        if (numRows <= 1) {
            return;
        }
        for (int i = 0; i < numRows; ++i) {
            int rowEnd = majorAxisPointers[i + 1];
            int rowStart = majorAxisPointers[i];
            int numCols = rowEnd - rowStart;
            if (numCols == 0) continue;
            if (numCols < 0) {
                throw new IllegalArgumentException("numCols SHOULD be greater than or equal to zero. numCols = rowEnd - rowStart = " + rowEnd + " - " + rowStart + " = " + numCols + " at i=" + i);
            }
            IntFloatPair[] pairs = new IntFloatPair[numCols];
            int jj = rowStart;
            int n = 0;
            while (jj < rowEnd) {
                pairs[n] = new IntFloatPair(minorAxisIndices[jj], values[jj]);
                ++jj;
                ++n;
            }
            Arrays.sort(pairs, new Comparator<IntFloatPair>(){

                @Override
                public int compare(IntFloatPair x, IntFloatPair y) {
                    return Integer.compare(x.key, y.key);
                }
            });
            jj = rowStart;
            n = 0;
            while (jj < rowEnd) {
                IntFloatPair tmp = pairs[n];
                minorAxisIndices[jj] = tmp.key;
                values[jj] = tmp.value;
                ++jj;
                ++n;
            }
        }
    }

    private static final class IntFloatPair {
        final int key;
        final float value;

        IntFloatPair(int key, float value) {
            this.key = key;
            this.value = value;
        }
    }

    private static final class IntDoublePair {
        final int key;
        final double value;

        IntDoublePair(int key, double value) {
            this.key = key;
            this.value = value;
        }
    }
}

