/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.AbstractMatrix;
import matrix4j.vector.Vector;
import matrix4j.vector.VectorProcedure;

public abstract class RowMajorMatrix
extends AbstractMatrix {
    @Override
    public boolean isRowMajorMatrix() {
        return true;
    }

    @Override
    public boolean isColumnMajorMatrix() {
        return false;
    }

    @Override
    public void getRow(@Nonnegative int index, final @Nonnull Vector row) {
        row.clear();
        this.eachNonNullInRow(index, new VectorProcedure(){

            @Override
            public void apply(int i, double value) {
                row.set(i, value);
            }
        });
    }

    @Override
    public void eachInColumn(int col, VectorProcedure procedure, boolean nullOutput) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void eachNonZeroInColumn(int col, VectorProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowMajorMatrix toRowMajorMatrix() {
        return this;
    }
}

