/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.builders;

import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.builders.MatrixBuilder;
import matrix4j.matrix.sparse.CSCMatrix;
import matrix4j.utils.collections.lists.DoubleArrayList;
import matrix4j.utils.collections.lists.IntArrayList;

public final class CSCMatrixBuilder
extends MatrixBuilder {
    @Nonnull
    private final IntArrayList rows;
    @Nonnull
    private final IntArrayList cols;
    @Nonnull
    private final DoubleArrayList values;
    private int row;
    private int maxNumColumns;

    public CSCMatrixBuilder(int initSize) {
        this.rows = new IntArrayList(initSize);
        this.cols = new IntArrayList(initSize);
        this.values = new DoubleArrayList(initSize);
        this.row = 0;
        this.maxNumColumns = 0;
    }

    @Override
    public CSCMatrixBuilder nextRow() {
        ++this.row;
        return this;
    }

    @Override
    public CSCMatrixBuilder nextColumn(@Nonnegative int col, double value) {
        CSCMatrixBuilder.checkColIndex(col);
        this.rows.add(this.row);
        this.cols.add(col);
        this.values.add(value);
        this.maxNumColumns = Math.max(col + 1, this.maxNumColumns);
        return this;
    }

    @Override
    public CSCMatrix buildMatrix() {
        int i;
        if (this.rows.isEmpty() || this.cols.isEmpty()) {
            throw new IllegalStateException("No element in the matrix");
        }
        int[] columnIndices = this.cols.toArray(true);
        int[] rowsIndices = this.rows.toArray(true);
        double[] valuesArray = this.values.toArray(true);
        int nnz = valuesArray.length;
        Object[] sortObjs = new SortObj[nnz];
        for (i = 0; i < nnz; ++i) {
            sortObjs[i] = new SortObj(columnIndices[i], rowsIndices[i], valuesArray[i]);
        }
        Arrays.sort(sortObjs);
        for (i = 0; i < nnz; ++i) {
            columnIndices[i] = ((SortObj)sortObjs[i]).columnIndex;
            rowsIndices[i] = ((SortObj)sortObjs[i]).rowsIndex;
            valuesArray[i] = ((SortObj)sortObjs[i]).value;
        }
        sortObjs = null;
        int[] columnPointers = new int[this.maxNumColumns + 1];
        int prevCol = -1;
        for (int j = 0; j < columnIndices.length; ++j) {
            int currCol = columnIndices[j];
            if (currCol == prevCol) continue;
            columnPointers[currCol] = j;
            prevCol = currCol;
        }
        columnPointers[this.maxNumColumns] = nnz;
        return new CSCMatrix(columnPointers, rowsIndices, valuesArray, this.row, this.maxNumColumns);
    }

    private static final class SortObj
    implements Comparable<SortObj> {
        final int columnIndex;
        final int rowsIndex;
        final double value;

        SortObj(int columnIndex, int rowsIndex, double value) {
            this.columnIndex = columnIndex;
            this.rowsIndex = rowsIndex;
            this.value = value;
        }

        @Override
        public int compareTo(SortObj o) {
            return Integer.compare(this.columnIndex, o.columnIndex);
        }
    }
}

