/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.builders.MatrixBuilder;
import matrix4j.matrix.sparse.CSRMatrix;
import matrix4j.utils.collections.lists.DoubleArrayList;
import matrix4j.utils.collections.lists.IntArrayList;

public final class CSRMatrixBuilder
extends MatrixBuilder {
    private final boolean sortRequired;
    @Nonnull
    private final IntArrayList rowPointers;
    @Nonnull
    private final IntArrayList columnIndices;
    @Nonnull
    private final DoubleArrayList values;
    @Nonnull
    private final List<ColValue> colCache;
    private int maxNumColumns;

    public CSRMatrixBuilder(@Nonnegative int initSize) {
        this(initSize, true);
    }

    public CSRMatrixBuilder(@Nonnegative int initSize, boolean sortRequired) {
        this.sortRequired = sortRequired;
        this.rowPointers = new IntArrayList(initSize + 1);
        this.rowPointers.add(0);
        this.columnIndices = new IntArrayList(initSize);
        this.values = new DoubleArrayList(initSize);
        this.colCache = new ArrayList<ColValue>(32);
        this.maxNumColumns = 0;
    }

    @Override
    public CSRMatrixBuilder nextRow() {
        if (this.sortRequired) {
            Collections.sort(this.colCache);
        }
        for (ColValue e : this.colCache) {
            this.columnIndices.add(e.col);
            this.values.add(e.value);
        }
        this.colCache.clear();
        int ptr = this.values.size();
        this.rowPointers.add(ptr);
        return this;
    }

    @Override
    public CSRMatrixBuilder nextColumn(@Nonnegative int col, double value) {
        CSRMatrixBuilder.checkColIndex(col);
        this.maxNumColumns = Math.max(col + 1, this.maxNumColumns);
        if (value == 0.0) {
            return this;
        }
        this.colCache.add(new ColValue(col, value));
        return this;
    }

    @Override
    public CSRMatrix buildMatrix() {
        CSRMatrix matrix = new CSRMatrix(this.rowPointers.toArray(true), this.columnIndices.toArray(true), this.values.toArray(true), this.maxNumColumns);
        return matrix;
    }

    private static final class ColValue
    implements Comparable<ColValue> {
        final int col;
        final double value;

        ColValue(int col, double value) {
            this.col = col;
            this.value = value;
        }

        @Override
        public int compareTo(ColValue o) {
            return Integer.compare(this.col, o.col);
        }

        public String toString() {
            return "[column=" + this.col + ", value=" + this.value + ']';
        }
    }
}

