/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.builders;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.builders.MatrixBuilder;
import matrix4j.matrix.dense.ColumnMajorDenseMatrix2d;
import matrix4j.utils.collections.Fastutil;
import matrix4j.utils.collections.arrays.SparseDoubleArray;

public final class ColumnMajorDenseMatrixBuilder
extends MatrixBuilder {
    @Nonnull
    private final Int2ObjectMap<SparseDoubleArray> col2rows;
    private int row;
    private int maxNumColumns;
    private int nnz;

    public ColumnMajorDenseMatrixBuilder(int initSize) {
        this.col2rows = new Int2ObjectOpenHashMap<SparseDoubleArray>(initSize);
        this.row = 0;
        this.maxNumColumns = 0;
        this.nnz = 0;
    }

    @Override
    public ColumnMajorDenseMatrixBuilder nextRow() {
        ++this.row;
        return this;
    }

    @Override
    public ColumnMajorDenseMatrixBuilder nextColumn(@Nonnegative int col, double value) {
        ColumnMajorDenseMatrixBuilder.checkColIndex(col);
        this.maxNumColumns = Math.max(col + 1, this.maxNumColumns);
        if (value == 0.0) {
            return this;
        }
        SparseDoubleArray rows = (SparseDoubleArray)this.col2rows.get(col);
        if (rows == null) {
            rows = new SparseDoubleArray(4);
            this.col2rows.put(col, rows);
        }
        rows.put(this.row, value);
        ++this.nnz;
        return this;
    }

    @Override
    public ColumnMajorDenseMatrix2d buildMatrix() {
        double[][] data = new double[this.maxNumColumns][];
        for (Int2ObjectMap.Entry entry : Fastutil.fastIterable(this.col2rows)) {
            int col = entry.getIntKey();
            SparseDoubleArray rows = (SparseDoubleArray)entry.getValue();
            data[col] = rows.toArray();
        }
        return new ColumnMajorDenseMatrix2d(data, this.row, this.nnz);
    }
}

