/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.builders;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.Matrix;

public abstract class MatrixBuilder {
    protected static final void checkColIndex(int col) {
        if (col < 0) {
            throw new IllegalArgumentException("Found negative column index: " + col);
        }
    }

    public void nextRow(@Nonnull double[] row) {
        for (int col = 0; col < row.length; ++col) {
            this.nextColumn(col, row[col]);
        }
        this.nextRow();
    }

    public void nextRow(@Nonnull String[] row) {
        for (String col : row) {
            if (col == null) continue;
            this.nextColumn(col);
        }
        this.nextRow();
    }

    @Nonnull
    public abstract MatrixBuilder nextRow();

    @Nonnull
    public abstract MatrixBuilder nextColumn(@Nonnegative int var1, double var2);

    @Nonnull
    public MatrixBuilder nextColumn(@Nonnull String col) {
        double value;
        String feature;
        int pos = col.indexOf(58);
        if (pos == 0) {
            throw new IllegalArgumentException("Invalid feature value representation: " + col);
        }
        if (pos > 0) {
            feature = col.substring(0, pos);
            String s2 = col.substring(pos + 1);
            value = Double.parseDouble(s2);
        } else {
            feature = col;
            value = 1.0;
        }
        if (feature.indexOf(58) != -1) {
            throw new IllegalArgumentException("Invalid feature format `<index>:<value>`: " + col);
        }
        int colIndex = Integer.parseInt(feature);
        if (colIndex < 0) {
            throw new IllegalArgumentException("Col index MUST be greater than or equals to 0: " + colIndex);
        }
        return this.nextColumn(colIndex, value);
    }

    @Nonnull
    public abstract Matrix buildMatrix();
}

