/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.builders;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.builders.MatrixBuilder;
import matrix4j.matrix.dense.RowMajorDenseMatrix2d;
import matrix4j.utils.collections.arrays.SparseDoubleArray;

public final class RowMajorDenseMatrixBuilder
extends MatrixBuilder {
    @Nonnull
    private final List<double[]> rows;
    private int maxNumColumns;
    private int nnz;
    @Nonnull
    private final SparseDoubleArray rowProbe;

    public RowMajorDenseMatrixBuilder(@Nonnegative int initSize) {
        this.rows = new ArrayList<double[]>(initSize);
        this.maxNumColumns = 0;
        this.nnz = 0;
        this.rowProbe = new SparseDoubleArray(32);
    }

    @Override
    public RowMajorDenseMatrixBuilder nextColumn(@Nonnegative int col, double value) {
        RowMajorDenseMatrixBuilder.checkColIndex(col);
        this.maxNumColumns = Math.max(col + 1, this.maxNumColumns);
        if (value == 0.0) {
            return this;
        }
        this.rowProbe.put(col, value);
        ++this.nnz;
        return this;
    }

    @Override
    public RowMajorDenseMatrixBuilder nextRow() {
        double[] row = this.rowProbe.toArray();
        this.rowProbe.clear();
        this.rows.add(row);
        return this;
    }

    @Override
    public void nextRow(@Nonnull double[] row) {
        for (double v : row) {
            if (v == 0.0) continue;
            ++this.nnz;
        }
        this.rows.add(row);
        this.maxNumColumns = Math.max(row.length, this.maxNumColumns);
    }

    @Override
    public RowMajorDenseMatrix2d buildMatrix() {
        int numRows = this.rows.size();
        double[][] data = (double[][])this.rows.toArray((T[])new double[numRows][]);
        return new RowMajorDenseMatrix2d(data, this.maxNumColumns, this.nnz);
    }
}

