/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.dense;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.ColumnMajorMatrix;
import matrix4j.matrix.builders.ColumnMajorDenseMatrixBuilder;
import matrix4j.matrix.dense.RowMajorDenseMatrix2d;
import matrix4j.utils.lang.Preconditions;
import matrix4j.vector.Vector;
import matrix4j.vector.VectorProcedure;

public final class ColumnMajorDenseMatrix2d
extends ColumnMajorMatrix {
    @Nonnull
    private final double[][] data;
    @Nonnegative
    private final int numRows;
    @Nonnegative
    private final int numColumns;
    @Nonnegative
    private int nnz;

    public ColumnMajorDenseMatrix2d(@Nonnull double[][] data, @Nonnegative int numRows) {
        this(data, numRows, ColumnMajorDenseMatrix2d.nnz(data));
    }

    public ColumnMajorDenseMatrix2d(@Nonnull double[][] data, @Nonnegative int numRows, @Nonnegative int nnz) {
        this.data = data;
        this.numRows = numRows;
        this.numColumns = data.length;
        this.nnz = nnz;
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public boolean readOnly() {
        return true;
    }

    @Override
    public boolean swappable() {
        return false;
    }

    @Override
    public int nnz() {
        return this.nnz;
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public int numColumns(int row) {
        ColumnMajorDenseMatrix2d.checkRowIndex(row, this.numRows);
        int numColumns = 0;
        for (int j = 0; j < this.data.length; ++j) {
            double[] col = this.data[j];
            if (col == null || row >= col.length || col[row] == 0.0) continue;
            ++numColumns;
        }
        return numColumns;
    }

    @Override
    public double[] getRow(int index) {
        ColumnMajorDenseMatrix2d.checkRowIndex(index, this.numRows);
        double[] row = new double[this.numColumns];
        return this.getRow(index, row);
    }

    @Override
    public double[] getRow(int index, @Nonnull double[] dst) {
        ColumnMajorDenseMatrix2d.checkRowIndex(index, this.numRows);
        for (int j = 0; j < this.data.length; ++j) {
            double[] col = this.data[j];
            if (col == null || index >= col.length) continue;
            dst[j] = col[index];
        }
        return dst;
    }

    @Override
    public void getRow(int index, @Nonnull Vector row) {
        ColumnMajorDenseMatrix2d.checkRowIndex(index, this.numRows);
        row.clear();
        for (int j = 0; j < this.data.length; ++j) {
            double[] col = this.data[j];
            if (col == null || index >= col.length) continue;
            double v = col[index];
            row.set(j, v);
        }
    }

    @Override
    public double get(int row, int col, double defaultValue) {
        ColumnMajorDenseMatrix2d.checkIndex(row, col, this.numRows, this.numColumns);
        double[] colData = this.data[col];
        if (colData == null || row >= colData.length) {
            return defaultValue;
        }
        return colData[row];
    }

    @Override
    public double getAndSet(int row, int col, double value) {
        ColumnMajorDenseMatrix2d.checkIndex(row, col, this.numRows, this.numColumns);
        double[] colData = this.data[col];
        Preconditions.checkNotNull(colData, "col does not exists: " + col);
        ColumnMajorDenseMatrix2d.checkRowIndex(row, colData.length);
        double old = colData[row];
        colData[row] = value;
        if (old == 0.0 && value != 0.0) {
            ++this.nnz;
        }
        return old;
    }

    @Override
    public void set(int row, int col, double value) {
        ColumnMajorDenseMatrix2d.checkIndex(row, col, this.numRows, this.numColumns);
        if (value == 0.0) {
            return;
        }
        double[] colData = this.data[col];
        Preconditions.checkNotNull(colData, "col does not exists: " + col);
        ColumnMajorDenseMatrix2d.checkRowIndex(row, colData.length);
        if (colData[row] == 0.0) {
            ++this.nnz;
        }
        colData[row] = value;
    }

    @Override
    public void swap(int row1, int row2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void eachInColumn(int col, @Nonnull VectorProcedure procedure, boolean nullOutput) {
        int row;
        ColumnMajorDenseMatrix2d.checkColIndex(col, this.numColumns);
        double[] colData = this.data[col];
        if (colData == null) {
            if (nullOutput) {
                for (int i = 0; i < this.numRows; ++i) {
                    procedure.apply(i, 0.0);
                }
            }
            return;
        }
        int len = colData.length;
        for (row = 0; row < len; ++row) {
            procedure.apply(row, colData[row]);
        }
        if (nullOutput) {
            while (row < this.numRows) {
                procedure.apply(row, 0.0);
                ++row;
            }
        }
    }

    @Override
    public void eachNonZeroInColumn(int col, @Nonnull VectorProcedure procedure) {
        ColumnMajorDenseMatrix2d.checkColIndex(col, this.numColumns);
        double[] colData = this.data[col];
        if (colData == null) {
            return;
        }
        int len = colData.length;
        for (int row = 0; row < len; ++row) {
            double v = colData[row];
            if (v == 0.0) continue;
            procedure.apply(row, v);
        }
    }

    @Override
    public RowMajorDenseMatrix2d toRowMajorMatrix() {
        double[][] rowcol = new double[this.numRows][this.numColumns];
        int nnz = 0;
        for (int j = 0; j < this.data.length; ++j) {
            double[] colData = this.data[j];
            if (colData == null) continue;
            for (int i = 0; i < colData.length; ++i) {
                double v = colData[i];
                if (v == 0.0) continue;
                rowcol[i][j] = v;
                ++nnz;
            }
        }
        for (int i = 0; i < rowcol.length; ++i) {
            int last;
            int maxj;
            double[] row = rowcol[i];
            for (maxj = last = this.numColumns - 1; maxj >= 0 && row[maxj] == 0.0; --maxj) {
            }
            if (maxj == last) continue;
            if (maxj < 0) {
                rowcol[i] = null;
                continue;
            }
            double[] dstRow = new double[maxj + 1];
            System.arraycopy(row, 0, dstRow, 0, dstRow.length);
            rowcol[i] = dstRow;
        }
        return new RowMajorDenseMatrix2d(rowcol, this.numColumns, nnz);
    }

    @Override
    public ColumnMajorDenseMatrixBuilder builder() {
        return new ColumnMajorDenseMatrixBuilder(this.numColumns);
    }

    private static int nnz(@Nonnull double[][] data) {
        int count = 0;
        for (int j = 0; j < data.length; ++j) {
            double[] col = data[j];
            if (col == null) continue;
            for (int i = 0; i < col.length; ++i) {
                if (col[i] == 0.0) continue;
                ++count;
            }
        }
        return count;
    }
}

