/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.dense;

import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.RowMajorMatrix;
import matrix4j.matrix.builders.RowMajorDenseMatrixBuilder;
import matrix4j.matrix.dense.ColumnMajorDenseMatrix2d;
import matrix4j.utils.lang.Preconditions;
import matrix4j.vector.DenseVector;
import matrix4j.vector.VectorProcedure;

public final class RowMajorDenseMatrix2d
extends RowMajorMatrix {
    @Nonnull
    private final double[][] data;
    @Nonnegative
    private final int numRows;
    @Nonnegative
    private final int numColumns;
    @Nonnegative
    private int nnz;

    public RowMajorDenseMatrix2d(@Nonnull double[][] data, @Nonnegative int numColumns) {
        this(data, numColumns, RowMajorDenseMatrix2d.nnz(data));
    }

    public RowMajorDenseMatrix2d(@Nonnull double[][] data, @Nonnegative int numColumns, @Nonnegative int nnz) {
        this.data = data;
        this.numRows = data.length;
        this.numColumns = numColumns;
        this.nnz = nnz;
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public boolean readOnly() {
        return true;
    }

    @Override
    public boolean swappable() {
        return true;
    }

    @Override
    public int nnz() {
        return this.nnz;
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public int numColumns(@Nonnegative int row) {
        RowMajorDenseMatrix2d.checkRowIndex(row, this.numRows);
        double[] r = this.data[row];
        if (r == null) {
            return 0;
        }
        return r.length;
    }

    @Override
    public DenseVector rowVector() {
        return new DenseVector(this.numColumns);
    }

    @Override
    public double[] getRow(@Nonnegative int index) {
        RowMajorDenseMatrix2d.checkRowIndex(index, this.numRows);
        double[] row = this.data[index];
        if (row == null) {
            return new double[0];
        }
        if (row.length == this.numRows) {
            return row;
        }
        double[] result = new double[this.numRows];
        System.arraycopy(row, 0, result, 0, row.length);
        return result;
    }

    @Override
    public double[] getRow(@Nonnull int index, @Nonnull double[] dst) {
        RowMajorDenseMatrix2d.checkRowIndex(index, this.numRows);
        double[] row = this.data[index];
        if (row == null) {
            return new double[0];
        }
        System.arraycopy(row, 0, dst, 0, row.length);
        if (dst.length > row.length) {
            Arrays.fill(dst, row.length, dst.length, 0.0);
        }
        return dst;
    }

    @Override
    public double get(@Nonnegative int row, @Nonnegative int col, double defaultValue) {
        RowMajorDenseMatrix2d.checkIndex(row, col, this.numRows, this.numColumns);
        double[] rowData = this.data[row];
        if (rowData == null || col >= rowData.length) {
            return defaultValue;
        }
        return rowData[col];
    }

    @Override
    public double getAndSet(@Nonnegative int row, @Nonnegative int col, double value) {
        RowMajorDenseMatrix2d.checkIndex(row, col, this.numRows, this.numColumns);
        double[] rowData = this.data[row];
        Preconditions.checkNotNull(rowData, "row does not exists: " + row);
        RowMajorDenseMatrix2d.checkColIndex(col, rowData.length);
        double old = rowData[col];
        rowData[col] = value;
        if (old == 0.0 && value != 0.0) {
            ++this.nnz;
        }
        return old;
    }

    @Override
    public void set(@Nonnegative int row, @Nonnegative int col, double value) {
        RowMajorDenseMatrix2d.checkIndex(row, col, this.numRows, this.numColumns);
        if (value == 0.0) {
            return;
        }
        double[] rowData = this.data[row];
        Preconditions.checkNotNull(rowData, "row does not exists: " + row);
        RowMajorDenseMatrix2d.checkColIndex(col, rowData.length);
        if (rowData[col] == 0.0) {
            ++this.nnz;
        }
        rowData[col] = value;
    }

    @Override
    public void swap(@Nonnegative int row1, @Nonnegative int row2) {
        RowMajorDenseMatrix2d.checkRowIndex(row1, this.numRows);
        RowMajorDenseMatrix2d.checkRowIndex(row2, this.numRows);
        double[] oldRow1 = this.data[row1];
        this.data[row1] = this.data[row2];
        this.data[row2] = oldRow1;
    }

    @Override
    public void eachInRow(@Nonnegative int row, @Nonnull VectorProcedure procedure, boolean nullOutput) {
        int col;
        RowMajorDenseMatrix2d.checkRowIndex(row, this.numRows);
        double[] rowData = this.data[row];
        if (rowData == null) {
            if (nullOutput) {
                for (int j = 0; j < this.numColumns; ++j) {
                    procedure.apply(j, 0.0);
                }
            }
            return;
        }
        int len = rowData.length;
        for (col = 0; col < len; ++col) {
            procedure.apply(col, rowData[col]);
        }
        if (nullOutput) {
            while (col < this.numColumns) {
                procedure.apply(col, 0.0);
                ++col;
            }
        }
    }

    @Override
    public void eachNonZeroInRow(@Nonnegative int row, @Nonnull VectorProcedure procedure) {
        RowMajorDenseMatrix2d.checkRowIndex(row, this.numRows);
        double[] rowData = this.data[row];
        if (rowData == null) {
            return;
        }
        int len = rowData.length;
        for (int col = 0; col < len; ++col) {
            double v = rowData[col];
            if (v == 0.0) continue;
            procedure.apply(col, v);
        }
    }

    @Override
    public void eachColumnIndexInRow(@Nonnegative int row, @Nonnull VectorProcedure procedure) {
        RowMajorDenseMatrix2d.checkRowIndex(row, this.numRows);
        double[] rowData = this.data[row];
        if (rowData == null) {
            return;
        }
        int len = rowData.length;
        for (int col = 0; col < len; ++col) {
            procedure.apply(col);
        }
    }

    @Override
    public void eachInColumn(@Nonnegative int col, @Nonnull VectorProcedure procedure, boolean nullOutput) {
        RowMajorDenseMatrix2d.checkColIndex(col, this.numColumns);
        for (int row = 0; row < this.numRows; ++row) {
            double[] rowData = this.data[row];
            if (rowData != null && col < rowData.length) {
                procedure.apply(row, rowData[col]);
                continue;
            }
            if (!nullOutput) continue;
            procedure.apply(row, 0.0);
        }
    }

    @Override
    public void eachNonZeroInColumn(@Nonnegative int col, @Nonnull VectorProcedure procedure) {
        RowMajorDenseMatrix2d.checkColIndex(col, this.numColumns);
        for (int row = 0; row < this.numRows; ++row) {
            double v;
            double[] rowData = this.data[row];
            if (rowData == null || col >= rowData.length || (v = rowData[col]) == 0.0) continue;
            procedure.apply(row, v);
        }
    }

    @Override
    public ColumnMajorDenseMatrix2d toColumnMajorMatrix() {
        double[][] colrow = new double[this.numColumns][this.numRows];
        int nnz = 0;
        for (int i = 0; i < this.data.length; ++i) {
            double[] rowData = this.data[i];
            if (rowData == null) continue;
            for (int j = 0; j < rowData.length; ++j) {
                double v = rowData[j];
                if (v == 0.0) continue;
                colrow[j][i] = v;
                ++nnz;
            }
        }
        for (int j = 0; j < colrow.length; ++j) {
            int last;
            int maxi;
            double[] col = colrow[j];
            for (maxi = last = this.numRows - 1; maxi >= 0 && col[maxi] == 0.0; --maxi) {
            }
            if (maxi == last) continue;
            if (maxi < 0) {
                colrow[j] = null;
                continue;
            }
            double[] dstCol = new double[maxi + 1];
            System.arraycopy(col, 0, dstCol, 0, dstCol.length);
            colrow[j] = dstCol;
        }
        return new ColumnMajorDenseMatrix2d(colrow, this.numRows, nnz);
    }

    @Override
    public RowMajorDenseMatrixBuilder builder() {
        return new RowMajorDenseMatrixBuilder(this.numRows);
    }

    private static int nnz(@Nonnull double[][] data) {
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            double[] row = data[i];
            if (row == null) continue;
            for (int j = 0; j < row.length; ++j) {
                if (row[j] == 0.0) continue;
                ++count;
            }
        }
        return count;
    }
}

