/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.ints;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.ints.IntMatrix;
import matrix4j.vector.VectorProcedure;

public abstract class AbstractIntMatrix
implements IntMatrix {
    protected int defaultValue = 0;

    @Override
    public void setDefaultValue(int value) {
        this.defaultValue = value;
    }

    @Override
    public int[] row() {
        int size = this.numRows();
        return new int[size];
    }

    @Override
    public final int get(@Nonnegative int row, @Nonnegative int col) {
        return this.get(row, col, this.defaultValue);
    }

    @Override
    public void incr(@Nonnegative int row, @Nonnegative int col) {
        this.incr(row, col, 1);
    }

    protected static final void checkRowIndex(int row, int numRows) {
        if (row < 0 || row >= numRows) {
            throw new IndexOutOfBoundsException("Row index " + row + " out of bounds " + numRows);
        }
    }

    protected static final void checkColIndex(int col, int numColumns) {
        if (col < 0 || col >= numColumns) {
            throw new IndexOutOfBoundsException("Col index " + col + " out of bounds " + numColumns);
        }
    }

    protected static final void checkIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
    }

    protected static final void checkIndex(int row, int col) {
        if (row < 0) {
            throw new IllegalArgumentException("Invalid row index: " + row);
        }
        if (col < 0) {
            throw new IllegalArgumentException("Invalid col index: " + col);
        }
    }

    protected static final void checkIndex(int row, int col, int numRows, int numColumns) {
        if (row < 0 || row >= numRows) {
            throw new IndexOutOfBoundsException("Row index " + row + " out of bounds " + numRows);
        }
        if (col < 0 || col >= numColumns) {
            throw new IndexOutOfBoundsException("Col index " + col + " out of bounds " + numColumns);
        }
    }

    protected static void rangeCheck(int length, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > length) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    @Override
    public void eachInRow(int row, @Nonnull VectorProcedure procedure) {
        this.eachInRow(row, procedure, true);
    }

    @Override
    public void eachInColumn(int col, @Nonnull VectorProcedure procedure) {
        this.eachInColumn(col, procedure, true);
    }

    @Override
    public void eachNonNullInRow(int row, @Nonnull VectorProcedure procedure) {
        this.eachInRow(row, procedure, false);
    }

    @Override
    public void eachNonNullInColumn(int col, @Nonnull VectorProcedure procedure) {
        this.eachInColumn(col, procedure, false);
    }
}

