/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.ints;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.ints.ColumnMajorIntMatrix;
import matrix4j.vector.VectorProcedure;

public final class ColumnMajorDenseIntMatrix2d
extends ColumnMajorIntMatrix {
    @Nonnull
    private final int[][] data;
    @Nonnegative
    private final int numRows;
    @Nonnegative
    private final int numColumns;

    public ColumnMajorDenseIntMatrix2d(@Nonnull int[][] data, @Nonnegative int numRows) {
        this.data = data;
        this.numRows = numRows;
        this.numColumns = data.length;
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public boolean readOnly() {
        return true;
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public int[] getRow(int index) {
        ColumnMajorDenseIntMatrix2d.checkRowIndex(index, this.numRows);
        int[] row = new int[this.numColumns];
        return this.getRow(index, row);
    }

    @Override
    public int[] getRow(int index, @Nonnull int[] dst) {
        ColumnMajorDenseIntMatrix2d.checkRowIndex(index, this.numRows);
        for (int j = 0; j < this.data.length; ++j) {
            int[] col = this.data[j];
            if (index >= col.length) continue;
            dst[j] = col[index];
        }
        return dst;
    }

    @Override
    public int get(int row, int col, int defaultValue) {
        ColumnMajorDenseIntMatrix2d.checkIndex(row, col, this.numRows, this.numColumns);
        int[] colData = this.data[col];
        if (row >= colData.length) {
            return defaultValue;
        }
        return colData[row];
    }

    @Override
    public int getAndSet(int row, int col, int value) {
        ColumnMajorDenseIntMatrix2d.checkIndex(row, col, this.numRows, this.numColumns);
        int[] colData = this.data[col];
        ColumnMajorDenseIntMatrix2d.checkRowIndex(row, colData.length);
        int old = colData[row];
        colData[row] = value;
        return old;
    }

    @Override
    public void set(int row, int col, int value) {
        ColumnMajorDenseIntMatrix2d.checkIndex(row, col, this.numRows, this.numColumns);
        if (value == 0) {
            return;
        }
        int[] colData = this.data[col];
        ColumnMajorDenseIntMatrix2d.checkRowIndex(row, colData.length);
        colData[row] = value;
    }

    @Override
    public void incr(int row, int col, int delta) {
        ColumnMajorDenseIntMatrix2d.checkIndex(row, col, this.numRows, this.numColumns);
        int[] colData = this.data[col];
        ColumnMajorDenseIntMatrix2d.checkRowIndex(row, colData.length);
        int n = row;
        colData[n] = colData[n] + delta;
    }

    @Override
    public void eachInColumn(int col, @Nonnull VectorProcedure procedure, boolean nullOutput) {
        int row;
        ColumnMajorDenseIntMatrix2d.checkColIndex(col, this.numColumns);
        int[] colData = this.data[col];
        if (colData == null) {
            if (nullOutput) {
                for (int i = 0; i < this.numRows; ++i) {
                    procedure.apply(i, this.defaultValue);
                }
            }
            return;
        }
        int len = colData.length;
        for (row = 0; row < len; ++row) {
            procedure.apply(row, colData[row]);
        }
        if (nullOutput) {
            while (row < this.numRows) {
                procedure.apply(row, this.defaultValue);
                ++row;
            }
        }
    }

    @Override
    public void eachNonZeroInColumn(int col, @Nonnull VectorProcedure procedure) {
        ColumnMajorDenseIntMatrix2d.checkColIndex(col, this.numColumns);
        int[] colData = this.data[col];
        if (colData == null) {
            return;
        }
        int len = colData.length;
        for (int row = 0; row < len; ++row) {
            int v = colData[row];
            if (v == 0) continue;
            procedure.apply(row, v);
        }
    }

    @Override
    public void eachNonNullInColumn(int col, int startRow, int endRow, @Nonnull VectorProcedure procedure) {
        ColumnMajorDenseIntMatrix2d.checkColIndex(col, this.numColumns);
        ColumnMajorDenseIntMatrix2d.rangeCheck(this.numRows, startRow, endRow);
        int[] colData = this.data[col];
        if (colData == null) {
            return;
        }
        int end = Math.min(endRow, colData.length);
        for (int row = startRow; row < end; ++row) {
            procedure.apply(row, colData[row]);
        }
    }

    @Override
    public void eachRow(@Nonnull VectorProcedure procedure) {
        for (int col = 0; col < this.data.length; ++col) {
            int[] row = this.data[col];
            if (row == null) continue;
            procedure.apply(col, row);
        }
    }
}

