/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.ints;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.ints.AbstractIntMatrix;
import matrix4j.utils.collections.maps.Long2IntOpenHashTable;
import matrix4j.utils.lang.Preconditions;
import matrix4j.utils.lang.Primitives;
import matrix4j.vector.VectorProcedure;

public final class DoKIntMatrix
extends AbstractIntMatrix {
    @Nonnull
    private final Long2IntOpenHashTable elements;
    @Nonnegative
    private int numRows;
    @Nonnegative
    private int numColumns;

    public DoKIntMatrix() {
        this(0, 0);
    }

    public DoKIntMatrix(@Nonnegative int numRows, @Nonnegative int numCols) {
        this(numRows, numCols, 0.05f);
    }

    public DoKIntMatrix(@Nonnegative int numRows, @Nonnegative int numCols, @Nonnegative float sparsity) {
        Preconditions.checkArgument(sparsity >= 0.0f && sparsity <= 1.0f, "Invalid Sparsity value: " + sparsity);
        int initialCapacity = Math.max(16384, Math.round((float)(numRows * numCols) * sparsity));
        this.elements = new Long2IntOpenHashTable(initialCapacity);
        this.numRows = numRows;
        this.numColumns = numCols;
    }

    private DoKIntMatrix(@Nonnull Long2IntOpenHashTable elements, @Nonnegative int numRows, @Nonnegative int numColumns) {
        this.elements = elements;
        this.numRows = numRows;
        this.numColumns = numColumns;
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    @Override
    public boolean readOnly() {
        return false;
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public int[] getRow(@Nonnegative int index) {
        int[] dst = this.row();
        return this.getRow(index, dst);
    }

    @Override
    public int[] getRow(@Nonnegative int row, @Nonnull int[] dst) {
        DoKIntMatrix.checkRowIndex(row, this.numRows);
        int end = Math.min(dst.length, this.numColumns);
        for (int col = 0; col < end; ++col) {
            int v;
            long index = DoKIntMatrix.index(row, col);
            dst[col] = v = this.elements.get(index, this.defaultValue);
        }
        return dst;
    }

    @Override
    public int get(@Nonnegative int row, @Nonnegative int col, int defaultValue) {
        DoKIntMatrix.checkIndex(row, col, this.numRows, this.numColumns);
        long index = DoKIntMatrix.index(row, col);
        return this.elements.get(index, defaultValue);
    }

    @Override
    public void set(@Nonnegative int row, @Nonnegative int col, int value) {
        DoKIntMatrix.checkIndex(row, col);
        long index = DoKIntMatrix.index(row, col);
        this.elements.put(index, value);
        this.numRows = Math.max(this.numRows, row + 1);
        this.numColumns = Math.max(this.numColumns, col + 1);
    }

    @Override
    public int getAndSet(@Nonnegative int row, @Nonnegative int col, int value) {
        DoKIntMatrix.checkIndex(row, col);
        long index = DoKIntMatrix.index(row, col);
        int old = this.elements.put(index, value);
        this.numRows = Math.max(this.numRows, row + 1);
        this.numColumns = Math.max(this.numColumns, col + 1);
        return old;
    }

    @Override
    public void incr(@Nonnegative int row, @Nonnegative int col, int delta) {
        DoKIntMatrix.checkIndex(row, col);
        long index = DoKIntMatrix.index(row, col);
        this.elements.incr(index, delta);
        this.numRows = Math.max(this.numRows, row + 1);
        this.numColumns = Math.max(this.numColumns, col + 1);
    }

    @Override
    public void eachInRow(@Nonnegative int row, @Nonnull VectorProcedure procedure, boolean nullOutput) {
        DoKIntMatrix.checkRowIndex(row, this.numRows);
        for (int col = 0; col < this.numColumns; ++col) {
            long i = DoKIntMatrix.index(row, col);
            int key = this.elements._findKey(i);
            if (key < 0) {
                if (!nullOutput) continue;
                procedure.apply(col, this.defaultValue);
                continue;
            }
            int v = this.elements._get(key);
            procedure.apply(col, v);
        }
    }

    @Override
    public void eachNonZeroInRow(@Nonnegative int row, @Nonnull VectorProcedure procedure) {
        DoKIntMatrix.checkRowIndex(row, this.numRows);
        for (int col = 0; col < this.numColumns; ++col) {
            long i = DoKIntMatrix.index(row, col);
            int v = this.elements.get(i, 0);
            if (v == 0) continue;
            procedure.apply(col, v);
        }
    }

    @Override
    public void eachInColumn(@Nonnegative int col, @Nonnull VectorProcedure procedure, boolean nullOutput) {
        DoKIntMatrix.checkColIndex(col, this.numColumns);
        for (int row = 0; row < this.numRows; ++row) {
            long i = DoKIntMatrix.index(row, col);
            int key = this.elements._findKey(i);
            if (key < 0) {
                if (!nullOutput) continue;
                procedure.apply(row, this.defaultValue);
                continue;
            }
            int v = this.elements._get(key);
            procedure.apply(row, v);
        }
    }

    @Override
    public void eachNonZeroInColumn(@Nonnegative int col, @Nonnull VectorProcedure procedure) {
        DoKIntMatrix.checkColIndex(col, this.numColumns);
        for (int row = 0; row < this.numRows; ++row) {
            long i = DoKIntMatrix.index(row, col);
            int v = this.elements.get(i, 0);
            if (v == 0) continue;
            procedure.apply(row, v);
        }
    }

    @Nonnegative
    private static long index(@Nonnegative int row, @Nonnegative int col) {
        return Primitives.toLong(row, col);
    }

    @Nonnull
    public static DoKIntMatrix build(@Nonnull int[][] matrix, boolean rowMajorInput, boolean nonZeroOnly) {
        if (rowMajorInput) {
            return DoKIntMatrix.buildFromRowMajorMatrix(matrix, nonZeroOnly);
        }
        return DoKIntMatrix.buildFromColumnMajorMatrix(matrix, nonZeroOnly);
    }

    @Nonnull
    private static DoKIntMatrix buildFromRowMajorMatrix(@Nonnull int[][] rowMajorMatrix, boolean nonZeroOnly) {
        Long2IntOpenHashTable elements = new Long2IntOpenHashTable(rowMajorMatrix.length * 3);
        int numRows = rowMajorMatrix.length;
        int numColumns = 0;
        for (int i = 0; i < rowMajorMatrix.length; ++i) {
            int[] row = rowMajorMatrix[i];
            if (row == null) continue;
            numColumns = Math.max(numColumns, row.length);
            for (int col = 0; col < row.length; ++col) {
                int value = row[col];
                if (nonZeroOnly && value == 0) continue;
                long index = DoKIntMatrix.index(i, col);
                elements.put(index, value);
            }
        }
        return new DoKIntMatrix(elements, numRows, numColumns);
    }

    @Nonnull
    private static DoKIntMatrix buildFromColumnMajorMatrix(@Nonnull int[][] columnMajorMatrix, boolean nonZeroOnly) {
        Long2IntOpenHashTable elements = new Long2IntOpenHashTable(columnMajorMatrix.length * 3);
        int numRows = 0;
        int numColumns = columnMajorMatrix.length;
        for (int j = 0; j < columnMajorMatrix.length; ++j) {
            int[] col = columnMajorMatrix[j];
            if (col == null) continue;
            numRows = Math.max(numRows, col.length);
            for (int row = 0; row < col.length; ++row) {
                int value = col[row];
                if (nonZeroOnly && value == 0) continue;
                long index = DoKIntMatrix.index(row, j);
                elements.put(index, value);
            }
        }
        return new DoKIntMatrix(elements, numRows, numColumns);
    }
}

