/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.sparse;

import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.ColumnMajorMatrix;
import matrix4j.matrix.builders.CSCMatrixBuilder;
import matrix4j.matrix.sparse.CSRMatrix;
import matrix4j.utils.lang.ArrayUtils;
import matrix4j.utils.lang.Preconditions;
import matrix4j.vector.Vector;
import matrix4j.vector.VectorProcedure;

public final class CSCMatrix
extends ColumnMajorMatrix {
    @Nonnull
    private final int[] columnPointers;
    @Nonnull
    private final int[] rowIndices;
    @Nonnull
    private final double[] values;
    private final int numRows;
    private final int numColumns;
    private final int nnz;

    public CSCMatrix(@Nonnull int[] columnPointers, @Nonnull int[] rowIndices, @Nonnull double[] values, int numRows, int numColumns) {
        Preconditions.checkArgument(columnPointers.length >= 1, "rowPointers must be greater than 0: " + columnPointers.length);
        Preconditions.checkArgument(rowIndices.length == values.length, "#rowIndices (" + rowIndices.length + ") must be equals to #values (" + values.length + ")");
        this.columnPointers = columnPointers;
        this.rowIndices = rowIndices;
        this.values = values;
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.nnz = values.length;
    }

    @Nonnull
    public int[] getColumnPointers() {
        return this.columnPointers;
    }

    @Nonnull
    public int[] getRowIndices() {
        return this.rowIndices;
    }

    @Nonnull
    public double[] getValues() {
        return this.values;
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    @Override
    public boolean readOnly() {
        return true;
    }

    @Override
    public boolean swappable() {
        return false;
    }

    @Override
    public int nnz() {
        return this.nnz;
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public int numColumns(int row) {
        CSCMatrix.checkRowIndex(row, this.numRows);
        return ArrayUtils.count(this.rowIndices, row);
    }

    @Override
    public double[] getRow(int index) {
        CSCMatrix.checkRowIndex(index, this.numRows);
        double[] row = new double[this.numColumns];
        int numCols = this.columnPointers.length - 1;
        for (int j = 0; j < numCols; ++j) {
            int k = Arrays.binarySearch(this.rowIndices, this.columnPointers[j], this.columnPointers[j + 1], index);
            if (k < 0) continue;
            row[j] = this.values[k];
        }
        return row;
    }

    @Override
    public double[] getRow(int index, @Nonnull double[] dst) {
        int j;
        CSCMatrix.checkRowIndex(index, this.numRows);
        int last = Math.min(dst.length, this.columnPointers.length - 1);
        for (j = 0; j < last; ++j) {
            int k = Arrays.binarySearch(this.rowIndices, this.columnPointers[j], this.columnPointers[j + 1], index);
            dst[j] = k >= 0 ? this.values[k] : 0.0;
        }
        for (j = last; j < dst.length; ++j) {
            dst[j] = 0.0;
        }
        return dst;
    }

    @Override
    public void getRow(int index, @Nonnull Vector row) {
        CSCMatrix.checkRowIndex(index, this.numRows);
        row.clear();
        int last = this.columnPointers.length - 1;
        for (int j = 0; j < last; ++j) {
            int k = Arrays.binarySearch(this.rowIndices, this.columnPointers[j], this.columnPointers[j + 1], index);
            if (k < 0) continue;
            double v = this.values[k];
            row.set(j, v);
        }
    }

    @Override
    public double get(int row, int col, double defaultValue) {
        CSCMatrix.checkIndex(row, col, this.numRows, this.numColumns);
        int index = this.getIndex(row, col);
        if (index < 0) {
            return defaultValue;
        }
        return this.values[index];
    }

    @Override
    public double getAndSet(int row, int col, double value) {
        CSCMatrix.checkIndex(row, col, this.numRows, this.numColumns);
        int index = this.getIndex(row, col);
        if (index < 0) {
            throw new UnsupportedOperationException("Cannot update value in row " + row + ", col " + col);
        }
        double old = this.values[index];
        this.values[index] = value;
        return old;
    }

    @Override
    public void set(int row, int col, double value) {
        CSCMatrix.checkIndex(row, col, this.numRows, this.numColumns);
        int index = this.getIndex(row, col);
        if (index < 0) {
            throw new UnsupportedOperationException("Cannot update value in row " + row + ", col " + col);
        }
        this.values[index] = value;
    }

    private int getIndex(@Nonnegative int row, @Nonnegative int col) {
        int leftIn = this.columnPointers[col];
        int rightEx = this.columnPointers[col + 1];
        int index = Arrays.binarySearch(this.rowIndices, leftIn, rightEx, row);
        if (index >= 0 && index >= this.values.length) {
            throw new IndexOutOfBoundsException("Value index " + index + " out of range " + this.values.length);
        }
        return index;
    }

    @Override
    public void swap(int row1, int row2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void eachInColumn(int col, @Nonnull VectorProcedure procedure, boolean nullOutput) {
        CSCMatrix.checkColIndex(col, this.numColumns);
        int startIn = this.columnPointers[col];
        int endEx = this.columnPointers[col + 1];
        if (nullOutput) {
            int i = startIn;
            for (int row = 0; row < this.numRows; ++row) {
                if (i < endEx && row == this.rowIndices[i]) {
                    double v = this.values[i++];
                    procedure.apply(row, v);
                    continue;
                }
                procedure.apply(row, 0.0);
            }
        } else {
            for (int j = startIn; j < endEx; ++j) {
                int row = this.rowIndices[j];
                double v = this.values[j];
                procedure.apply(row, v);
            }
        }
    }

    @Override
    public void eachNonZeroInColumn(int col, @Nonnull VectorProcedure procedure) {
        CSCMatrix.checkColIndex(col, this.numColumns);
        int startIn = this.columnPointers[col];
        int endEx = this.columnPointers[col + 1];
        for (int j = startIn; j < endEx; ++j) {
            int row = this.rowIndices[j];
            double v = this.values[j];
            if (v == 0.0) continue;
            procedure.apply(row, v);
        }
    }

    @Override
    public CSRMatrix toRowMajorMatrix() {
        int i;
        int[] rowPointers = new int[this.numRows + 1];
        int[] colIndices = new int[this.nnz];
        double[] csrValues = new double[this.nnz];
        for (i = 0; i < this.rowIndices.length; ++i) {
            int n = this.rowIndices[i];
            rowPointers[n] = rowPointers[n] + 1;
        }
        int sum = 0;
        for (i = 0; i < this.numRows; ++i) {
            int curr = rowPointers[i];
            rowPointers[i] = sum;
            sum += curr;
        }
        rowPointers[this.numRows] = this.nnz;
        for (int j = 0; j < this.numColumns; ++j) {
            int last = this.columnPointers[j + 1];
            for (int i2 = this.columnPointers[j]; i2 < last; ++i2) {
                int col = this.rowIndices[i2];
                int dst = rowPointers[col];
                colIndices[dst] = j;
                csrValues[dst] = this.values[i2];
                int n = col;
                rowPointers[n] = rowPointers[n] + 1;
            }
        }
        int last = 0;
        for (i = 0; i <= this.numRows; ++i) {
            int tmp = rowPointers[i];
            rowPointers[i] = last;
            last = tmp;
        }
        return new CSRMatrix(rowPointers, colIndices, csrValues, this.numColumns);
    }

    @Override
    public CSCMatrixBuilder builder() {
        return new CSCMatrixBuilder(this.nnz);
    }
}

