/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.sparse;

import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.RowMajorMatrix;
import matrix4j.matrix.builders.CSRMatrixBuilder;
import matrix4j.matrix.sparse.CSCMatrix;
import matrix4j.utils.lang.Preconditions;
import matrix4j.vector.VectorProcedure;

public final class CSRMatrix
extends RowMajorMatrix {
    @Nonnull
    private final int[] rowPointers;
    @Nonnull
    private final int[] columnIndices;
    @Nonnull
    private final double[] values;
    @Nonnegative
    private final int numRows;
    @Nonnegative
    private final int numColumns;
    @Nonnegative
    private final int nnz;

    public CSRMatrix(@Nonnull int[] rowPointers, @Nonnull int[] columnIndices, @Nonnull double[] values, @Nonnegative int numColumns) {
        Preconditions.checkArgument(rowPointers.length >= 1, "rowPointers must be greater than 0: " + rowPointers.length);
        Preconditions.checkArgument(columnIndices.length == values.length, "#columnIndices (" + columnIndices.length + ") must be equals to #values (" + values.length + ")");
        this.rowPointers = rowPointers;
        this.columnIndices = columnIndices;
        this.values = values;
        this.numRows = rowPointers.length - 1;
        this.numColumns = numColumns;
        this.nnz = values.length;
    }

    @Nonnull
    public int[] getRowPointers() {
        return this.rowPointers;
    }

    @Nonnull
    public int[] getColumnIndices() {
        return this.columnIndices;
    }

    @Nonnull
    public double[] getValues() {
        return this.values;
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    @Override
    public boolean readOnly() {
        return true;
    }

    @Override
    public boolean swappable() {
        return false;
    }

    @Override
    public int nnz() {
        return this.nnz;
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public int numColumns(@Nonnegative int row) {
        CSRMatrix.checkRowIndex(row, this.numRows);
        int columns = this.rowPointers[row + 1] - this.rowPointers[row];
        return columns;
    }

    @Override
    public double[] getRow(@Nonnegative int index) {
        final double[] row = new double[this.numColumns];
        this.eachNonZeroInRow(index, new VectorProcedure(){

            @Override
            public void apply(int col, double value) {
                row[col] = value;
            }
        });
        return row;
    }

    @Override
    public double[] getRow(@Nonnegative int index, final @Nonnull double[] dst) {
        Arrays.fill(dst, 0.0);
        this.eachNonZeroInRow(index, new VectorProcedure(){

            @Override
            public void apply(int col, double value) {
                CSRMatrix.checkColIndex(col, CSRMatrix.this.numColumns);
                dst[col] = value;
            }
        });
        return dst;
    }

    @Override
    public double get(@Nonnegative int row, @Nonnegative int col, double defaultValue) {
        CSRMatrix.checkIndex(row, col, this.numRows, this.numColumns);
        int index = this.getIndex(row, col);
        if (index < 0) {
            return defaultValue;
        }
        return this.values[index];
    }

    @Override
    public double getAndSet(@Nonnegative int row, @Nonnegative int col, double value) {
        CSRMatrix.checkIndex(row, col, this.numRows, this.numColumns);
        int index = this.getIndex(row, col);
        if (index < 0) {
            throw new UnsupportedOperationException("Cannot update value in row " + row + ", col " + col);
        }
        double old = this.values[index];
        this.values[index] = value;
        return old;
    }

    @Override
    public void set(@Nonnegative int row, @Nonnegative int col, double value) {
        CSRMatrix.checkIndex(row, col, this.numRows, this.numColumns);
        int index = this.getIndex(row, col);
        if (index < 0) {
            throw new UnsupportedOperationException("Cannot update value in row " + row + ", col " + col);
        }
        this.values[index] = value;
    }

    private int getIndex(@Nonnegative int row, @Nonnegative int col) {
        int leftIn = this.rowPointers[row];
        int rightEx = this.rowPointers[row + 1];
        int index = Arrays.binarySearch(this.columnIndices, leftIn, rightEx, col);
        if (index >= 0 && index >= this.values.length) {
            throw new IndexOutOfBoundsException("Value index " + index + " out of range " + this.values.length);
        }
        return index;
    }

    @Override
    public void swap(int row1, int row2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void eachInRow(@Nonnegative int row, @Nonnull VectorProcedure procedure, boolean nullOutput) {
        CSRMatrix.checkRowIndex(row, this.numRows);
        int startIn = this.rowPointers[row];
        int endEx = this.rowPointers[row + 1];
        if (nullOutput) {
            int j = startIn;
            for (int col = 0; col < this.numColumns; ++col) {
                if (j < endEx && col == this.columnIndices[j]) {
                    double v = this.values[j++];
                    procedure.apply(col, v);
                    continue;
                }
                procedure.apply(col, 0.0);
            }
        } else {
            for (int i = startIn; i < endEx; ++i) {
                procedure.apply(this.columnIndices[i], this.values[i]);
            }
        }
    }

    @Override
    public void eachNonZeroInRow(@Nonnegative int row, @Nonnull VectorProcedure procedure) {
        CSRMatrix.checkRowIndex(row, this.numRows);
        int startIn = this.rowPointers[row];
        int endEx = this.rowPointers[row + 1];
        for (int i = startIn; i < endEx; ++i) {
            int col = this.columnIndices[i];
            double v = this.values[i];
            if (v == 0.0) continue;
            procedure.apply(col, v);
        }
    }

    @Override
    public void eachColumnIndexInRow(@Nonnegative int row, @Nonnull VectorProcedure procedure) {
        CSRMatrix.checkRowIndex(row, this.numRows);
        int startIn = this.rowPointers[row];
        int endEx = this.rowPointers[row + 1];
        for (int i = startIn; i < endEx; ++i) {
            procedure.apply(this.columnIndices[i]);
        }
    }

    @Override
    @Nonnull
    public CSCMatrix toColumnMajorMatrix() {
        int j;
        int[] columnPointers = new int[this.numColumns + 1];
        int[] rowIndices = new int[this.nnz];
        double[] cscValues = new double[this.nnz];
        for (j = 0; j < this.columnIndices.length; ++j) {
            int n = this.columnIndices[j];
            columnPointers[n] = columnPointers[n] + 1;
        }
        int sum = 0;
        for (j = 0; j < this.numColumns; ++j) {
            int curr = columnPointers[j];
            columnPointers[j] = sum;
            sum += curr;
        }
        columnPointers[this.numColumns] = this.nnz;
        for (int i = 0; i < this.numRows; ++i) {
            int last = this.rowPointers[i + 1];
            for (int j2 = this.rowPointers[i]; j2 < last; ++j2) {
                int col = this.columnIndices[j2];
                int dst = columnPointers[col];
                rowIndices[dst] = i;
                cscValues[dst] = this.values[j2];
                int n = col;
                columnPointers[n] = columnPointers[n] + 1;
            }
        }
        int last = 0;
        for (j = 0; j <= this.numColumns; ++j) {
            int tmp = columnPointers[j];
            columnPointers[j] = last;
            last = tmp;
        }
        return new CSCMatrix(columnPointers, rowIndices, cscValues, this.numRows, this.numColumns);
    }

    @Override
    public CSRMatrixBuilder builder() {
        return new CSRMatrixBuilder(this.values.length);
    }
}

