/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.sparse;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.AbstractMatrix;
import matrix4j.matrix.ColumnMajorMatrix;
import matrix4j.matrix.MatrixUtils;
import matrix4j.matrix.RowMajorMatrix;
import matrix4j.matrix.builders.DoKMatrixBuilder;
import matrix4j.utils.collections.maps.Long2DoubleOpenHashTable;
import matrix4j.utils.lang.Preconditions;
import matrix4j.utils.lang.Primitives;
import matrix4j.vector.Vector;
import matrix4j.vector.VectorProcedure;

public final class DoKMatrix
extends AbstractMatrix {
    @Nonnull
    private final Long2DoubleOpenHashTable elements;
    @Nonnegative
    private int numRows;
    @Nonnegative
    private int numColumns;

    public DoKMatrix() {
        this(0, 0);
    }

    public DoKMatrix(@Nonnegative int numRows, @Nonnegative int numCols) {
        this(numRows, numCols, 0.05f);
    }

    public DoKMatrix(@Nonnegative int numRows, @Nonnegative int numCols, @Nonnegative float sparsity) {
        Preconditions.checkArgument(sparsity >= 0.0f && sparsity <= 1.0f, "Invalid Sparsity value: " + sparsity);
        int initialCapacity = Math.max(16384, Math.round((float)(numRows * numCols) * sparsity));
        this.elements = new Long2DoubleOpenHashTable(initialCapacity);
        this.elements.defaultReturnValue(0.0);
        this.numRows = numRows;
        this.numColumns = numCols;
    }

    public DoKMatrix(@Nonnegative int initSize) {
        int initialCapacity = Math.max(initSize, 16384);
        this.elements = new Long2DoubleOpenHashTable(initialCapacity);
        this.elements.defaultReturnValue(0.0);
        this.numRows = 0;
        this.numColumns = 0;
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    @Override
    public boolean isRowMajorMatrix() {
        return false;
    }

    @Override
    public boolean isColumnMajorMatrix() {
        return false;
    }

    @Override
    public boolean readOnly() {
        return false;
    }

    @Override
    public boolean swappable() {
        return true;
    }

    @Override
    public int nnz() {
        return this.elements.size();
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public int numColumns(@Nonnegative int row) {
        int count = 0;
        for (int j = 0; j < this.numColumns; ++j) {
            long index = DoKMatrix.index(row, j);
            if (!this.elements.containsKey(index)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public double[] getRow(@Nonnegative int index) {
        double[] dst = this.row();
        return this.getRow(index, dst);
    }

    @Override
    public double[] getRow(@Nonnegative int row, @Nonnull double[] dst) {
        DoKMatrix.checkRowIndex(row, this.numRows);
        int end = Math.min(dst.length, this.numColumns);
        for (int col = 0; col < end; ++col) {
            double v;
            long k = DoKMatrix.index(row, col);
            dst[col] = v = this.elements.get(k);
        }
        return dst;
    }

    @Override
    public void getRow(@Nonnegative int index, @Nonnull Vector row) {
        DoKMatrix.checkRowIndex(index, this.numRows);
        row.clear();
        for (int col = 0; col < this.numColumns; ++col) {
            long k = DoKMatrix.index(index, col);
            double v = this.elements.get(k, 0.0);
            if (v == 0.0) continue;
            row.set(col, v);
        }
    }

    @Override
    public double get(@Nonnegative int row, @Nonnegative int col, double defaultValue) {
        long index = DoKMatrix.index(row, col);
        return this.elements.get(index, defaultValue);
    }

    @Override
    public void set(@Nonnegative int row, @Nonnegative int col, double value) {
        DoKMatrix.checkIndex(row, col);
        long index = DoKMatrix.index(row, col);
        this.elements.put(index, value);
        this.numRows = Math.max(this.numRows, row + 1);
        this.numColumns = Math.max(this.numColumns, col + 1);
    }

    @Override
    public double getAndSet(@Nonnegative int row, @Nonnegative int col, double value) {
        DoKMatrix.checkIndex(row, col);
        long index = DoKMatrix.index(row, col);
        double old = this.elements.put(index, value);
        this.numRows = Math.max(this.numRows, row + 1);
        this.numColumns = Math.max(this.numColumns, col + 1);
        return old;
    }

    @Override
    public void swap(@Nonnegative int row1, @Nonnegative int row2) {
        DoKMatrix.checkRowIndex(row1, this.numRows);
        DoKMatrix.checkRowIndex(row2, this.numRows);
        for (int j = 0; j < this.numColumns; ++j) {
            long i1 = DoKMatrix.index(row1, j);
            long i2 = DoKMatrix.index(row2, j);
            int k1 = this.elements._findKey(i1);
            int k2 = this.elements._findKey(i2);
            if (k1 >= 0) {
                double v1;
                if (k2 >= 0) {
                    v1 = this.elements._get(k1);
                    double v2 = this.elements._set(k2, v1);
                    this.elements._set(k1, v2);
                    continue;
                }
                v1 = this.elements._remove(k1);
                this.elements.put(i2, v1);
                continue;
            }
            if (k2 < 0) continue;
            double v2 = this.elements._remove(k2);
            this.elements.put(i1, v2);
        }
    }

    @Override
    public void eachInRow(@Nonnegative int row, @Nonnull VectorProcedure procedure, boolean nullOutput) {
        DoKMatrix.checkRowIndex(row, this.numRows);
        for (int col = 0; col < this.numColumns; ++col) {
            long i = DoKMatrix.index(row, col);
            int key = this.elements._findKey(i);
            if (key < 0) {
                if (!nullOutput) continue;
                procedure.apply(col, 0.0);
                continue;
            }
            double v = this.elements._get(key);
            procedure.apply(col, v);
        }
    }

    @Override
    public void eachNonZeroInRow(@Nonnegative int row, @Nonnull VectorProcedure procedure) {
        DoKMatrix.checkRowIndex(row, this.numRows);
        for (int col = 0; col < this.numColumns; ++col) {
            long i = DoKMatrix.index(row, col);
            double v = this.elements.get(i, 0.0);
            if (v == 0.0) continue;
            procedure.apply(col, v);
        }
    }

    @Override
    public void eachColumnIndexInRow(int row, VectorProcedure procedure) {
        DoKMatrix.checkRowIndex(row, this.numRows);
        for (int col = 0; col < this.numColumns; ++col) {
            long i = DoKMatrix.index(row, col);
            int key = this.elements._findKey(i);
            if (key == -1) continue;
            procedure.apply(col);
        }
    }

    @Override
    public void eachInColumn(@Nonnegative int col, @Nonnull VectorProcedure procedure, boolean nullOutput) {
        DoKMatrix.checkColIndex(col, this.numColumns);
        for (int row = 0; row < this.numRows; ++row) {
            long i = DoKMatrix.index(row, col);
            int key = this.elements._findKey(i);
            if (key < 0) {
                if (!nullOutput) continue;
                procedure.apply(row, 0.0);
                continue;
            }
            double v = this.elements._get(key);
            procedure.apply(row, v);
        }
    }

    @Override
    public void eachNonZeroInColumn(@Nonnegative int col, @Nonnull VectorProcedure procedure) {
        DoKMatrix.checkColIndex(col, this.numColumns);
        for (int row = 0; row < this.numRows; ++row) {
            long i = DoKMatrix.index(row, col);
            double v = this.elements.get(i, 0.0);
            if (v == 0.0) continue;
            procedure.apply(row, v);
        }
    }

    @Override
    public void eachNonZeroCell(@Nonnull VectorProcedure procedure) {
        if (this.elements.size() == 0) {
            return;
        }
        Long2DoubleOpenHashTable.IMapIterator itor = this.elements.entries();
        while (itor.next() != -1) {
            long k = itor.getKey();
            int row = Primitives.getHigh(k);
            int col = Primitives.getLow(k);
            double value = itor.getValue();
            procedure.apply(row, col, value);
        }
    }

    @Override
    public RowMajorMatrix toRowMajorMatrix() {
        int nnz = this.elements.size();
        int[] rows = new int[nnz];
        int[] cols = new int[nnz];
        double[] data = new double[nnz];
        Long2DoubleOpenHashTable.IMapIterator itor = this.elements.entries();
        for (int i = 0; i < nnz; ++i) {
            if (itor.next() == -1) {
                throw new IllegalStateException("itor.next() returns -1 where i=" + i);
            }
            long k = itor.getKey();
            rows[i] = Primitives.getHigh(k);
            cols[i] = Primitives.getLow(k);
            data[i] = itor.getValue();
        }
        return MatrixUtils.coo2csr(rows, cols, data, this.numRows, this.numColumns, true);
    }

    @Override
    public ColumnMajorMatrix toColumnMajorMatrix() {
        int nnz = this.elements.size();
        int[] rows = new int[nnz];
        int[] cols = new int[nnz];
        double[] data = new double[nnz];
        Long2DoubleOpenHashTable.IMapIterator itor = this.elements.entries();
        for (int i = 0; i < nnz; ++i) {
            if (itor.next() == -1) {
                throw new IllegalStateException("itor.next() returns -1 where i=" + i);
            }
            long k = itor.getKey();
            rows[i] = Primitives.getHigh(k);
            cols[i] = Primitives.getLow(k);
            data[i] = itor.getValue();
        }
        return MatrixUtils.coo2csc(rows, cols, data, this.numRows, this.numColumns, true);
    }

    @Override
    public DoKMatrixBuilder builder() {
        return new DoKMatrixBuilder(this.elements.size());
    }

    @Nonnegative
    private static long index(@Nonnegative int row, @Nonnegative int col) {
        return Primitives.toLong(row, col);
    }
}

