/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.matrix.sparse.floats;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.matrix.AbstractMatrix;
import matrix4j.matrix.FloatMatrix;
import matrix4j.matrix.MatrixUtils;
import matrix4j.matrix.builders.DoKMatrixBuilder;
import matrix4j.matrix.sparse.floats.CSCFloatMatrix;
import matrix4j.matrix.sparse.floats.CSRFloatMatrix;
import matrix4j.utils.collections.maps.Long2FloatOpenHashTable;
import matrix4j.utils.lang.Preconditions;
import matrix4j.utils.lang.Primitives;
import matrix4j.vector.Vector;
import matrix4j.vector.VectorProcedure;

public final class DoKFloatMatrix
extends AbstractMatrix
implements FloatMatrix {
    @Nonnull
    private final Long2FloatOpenHashTable elements;
    @Nonnegative
    private int numRows;
    @Nonnegative
    private int numColumns;

    public DoKFloatMatrix() {
        this(0, 0);
    }

    public DoKFloatMatrix(@Nonnegative int numRows, @Nonnegative int numCols) {
        this(numRows, numCols, 0.05f);
    }

    public DoKFloatMatrix(@Nonnegative int numRows, @Nonnegative int numCols, @Nonnegative float sparsity) {
        Preconditions.checkArgument(sparsity >= 0.0f && sparsity <= 1.0f, "Invalid Sparsity value: " + sparsity);
        int initialCapacity = Math.max(16384, Math.round((float)(numRows * numCols) * sparsity));
        this.elements = new Long2FloatOpenHashTable(initialCapacity);
        this.elements.defaultReturnValue(0.0f);
        this.numRows = numRows;
        this.numColumns = numCols;
    }

    public DoKFloatMatrix(@Nonnegative int initSize) {
        int initialCapacity = Math.max(initSize, 16384);
        this.elements = new Long2FloatOpenHashTable(initialCapacity);
        this.elements.defaultReturnValue(0.0f);
        this.numRows = 0;
        this.numColumns = 0;
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    @Override
    public boolean isRowMajorMatrix() {
        return false;
    }

    @Override
    public boolean isColumnMajorMatrix() {
        return false;
    }

    @Override
    public boolean readOnly() {
        return false;
    }

    @Override
    public boolean swappable() {
        return true;
    }

    @Override
    public int nnz() {
        return this.elements.size();
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public int numColumns(@Nonnegative int row) {
        int count = 0;
        for (int j = 0; j < this.numColumns; ++j) {
            long index = DoKFloatMatrix.index(row, j);
            if (!this.elements.containsKey(index)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public double[] getRow(@Nonnegative int index) {
        double[] dst = this.row();
        return this.getRow(index, dst);
    }

    @Override
    public double[] getRow(@Nonnegative int row, @Nonnull double[] dst) {
        DoKFloatMatrix.checkRowIndex(row, this.numRows);
        int end = Math.min(dst.length, this.numColumns);
        for (int col = 0; col < end; ++col) {
            long k = DoKFloatMatrix.index(row, col);
            float v = this.elements.get(k);
            dst[col] = v;
        }
        return dst;
    }

    @Override
    public float[] getRow(@Nonnegative int row, @Nonnull float[] dst) {
        DoKFloatMatrix.checkRowIndex(row, this.numRows);
        int end = Math.min(dst.length, this.numColumns);
        for (int col = 0; col < end; ++col) {
            float v;
            long k = DoKFloatMatrix.index(row, col);
            dst[col] = v = this.elements.get(k);
        }
        return dst;
    }

    @Override
    public void getRow(@Nonnegative int index, @Nonnull Vector row) {
        DoKFloatMatrix.checkRowIndex(index, this.numRows);
        row.clear();
        for (int col = 0; col < this.numColumns; ++col) {
            long k = DoKFloatMatrix.index(index, col);
            float v = this.elements.get(k, 0.0f);
            if (v == 0.0f) continue;
            row.set(col, v);
        }
    }

    @Override
    public float get(@Nonnegative int row, @Nonnegative int col, float defaultValue) {
        long index = DoKFloatMatrix.index(row, col);
        return this.elements.get(index, defaultValue);
    }

    @Override
    public void set(@Nonnegative int row, @Nonnegative int col, float value) {
        DoKFloatMatrix.checkIndex(row, col);
        long index = DoKFloatMatrix.index(row, col);
        this.elements.put(index, value);
        this.numRows = Math.max(this.numRows, row + 1);
        this.numColumns = Math.max(this.numColumns, col + 1);
    }

    @Override
    public float getAndSet(@Nonnegative int row, @Nonnegative int col, float value) {
        DoKFloatMatrix.checkIndex(row, col);
        long index = DoKFloatMatrix.index(row, col);
        float old = this.elements.put(index, value);
        this.numRows = Math.max(this.numRows, row + 1);
        this.numColumns = Math.max(this.numColumns, col + 1);
        return old;
    }

    @Override
    public void swap(@Nonnegative int row1, @Nonnegative int row2) {
        DoKFloatMatrix.checkRowIndex(row1, this.numRows);
        DoKFloatMatrix.checkRowIndex(row2, this.numRows);
        for (int j = 0; j < this.numColumns; ++j) {
            long i1 = DoKFloatMatrix.index(row1, j);
            long i2 = DoKFloatMatrix.index(row2, j);
            int k1 = this.elements._findKey(i1);
            int k2 = this.elements._findKey(i2);
            if (k1 >= 0) {
                float v1;
                if (k2 >= 0) {
                    v1 = this.elements._get(k1);
                    float v2 = this.elements._set(k2, v1);
                    this.elements._set(k1, v2);
                    continue;
                }
                v1 = this.elements._remove(k1);
                this.elements.put(i2, v1);
                continue;
            }
            if (k2 < 0) continue;
            float v2 = this.elements._remove(k2);
            this.elements.put(i1, v2);
        }
    }

    @Override
    public void eachInRow(@Nonnegative int row, @Nonnull VectorProcedure procedure, boolean nullOutput) {
        DoKFloatMatrix.checkRowIndex(row, this.numRows);
        for (int col = 0; col < this.numColumns; ++col) {
            long i = DoKFloatMatrix.index(row, col);
            int key = this.elements._findKey(i);
            if (key < 0) {
                if (!nullOutput) continue;
                procedure.apply(col, 0.0f);
                continue;
            }
            float v = this.elements._get(key);
            procedure.apply(col, v);
        }
    }

    @Override
    public void eachNonZeroInRow(@Nonnegative int row, @Nonnull VectorProcedure procedure) {
        DoKFloatMatrix.checkRowIndex(row, this.numRows);
        for (int col = 0; col < this.numColumns; ++col) {
            long i = DoKFloatMatrix.index(row, col);
            float v = this.elements.get(i, 0.0f);
            if (v == 0.0f) continue;
            procedure.apply(col, v);
        }
    }

    @Override
    public void eachColumnIndexInRow(int row, VectorProcedure procedure) {
        DoKFloatMatrix.checkRowIndex(row, this.numRows);
        for (int col = 0; col < this.numColumns; ++col) {
            long i = DoKFloatMatrix.index(row, col);
            int key = this.elements._findKey(i);
            if (key == -1) continue;
            procedure.apply(col);
        }
    }

    @Override
    public void eachInColumn(@Nonnegative int col, @Nonnull VectorProcedure procedure, boolean nullOutput) {
        DoKFloatMatrix.checkColIndex(col, this.numColumns);
        for (int row = 0; row < this.numRows; ++row) {
            long i = DoKFloatMatrix.index(row, col);
            int key = this.elements._findKey(i);
            if (key < 0) {
                if (!nullOutput) continue;
                procedure.apply(row, 0.0f);
                continue;
            }
            float v = this.elements._get(key);
            procedure.apply(row, v);
        }
    }

    @Override
    public void eachNonZeroInColumn(@Nonnegative int col, @Nonnull VectorProcedure procedure) {
        DoKFloatMatrix.checkColIndex(col, this.numColumns);
        for (int row = 0; row < this.numRows; ++row) {
            long i = DoKFloatMatrix.index(row, col);
            float v = this.elements.get(i, 0.0f);
            if (v == 0.0f) continue;
            procedure.apply(row, v);
        }
    }

    @Override
    public void eachNonZeroCell(@Nonnull VectorProcedure procedure) {
        if (this.elements.size() == 0) {
            return;
        }
        Long2FloatOpenHashTable.IMapIterator itor = this.elements.entries();
        while (itor.next() != -1) {
            long k = itor.getKey();
            int row = Primitives.getHigh(k);
            int col = Primitives.getLow(k);
            float value = itor.getValue();
            procedure.apply(row, col, value);
        }
    }

    @Override
    public CSRFloatMatrix toRowMajorMatrix() {
        int nnz = this.elements.size();
        int[] rows = new int[nnz];
        int[] cols = new int[nnz];
        float[] data = new float[nnz];
        Long2FloatOpenHashTable.IMapIterator itor = this.elements.entries();
        for (int i = 0; i < nnz; ++i) {
            if (itor.next() == -1) {
                throw new IllegalStateException("itor.next() returns -1 where i=" + i);
            }
            long k = itor.getKey();
            rows[i] = Primitives.getHigh(k);
            cols[i] = Primitives.getLow(k);
            data[i] = itor.getValue();
        }
        return MatrixUtils.coo2csr(rows, cols, data, this.numRows, this.numColumns, true);
    }

    @Override
    public CSCFloatMatrix toColumnMajorMatrix() {
        int nnz = this.elements.size();
        int[] rows = new int[nnz];
        int[] cols = new int[nnz];
        float[] data = new float[nnz];
        Long2FloatOpenHashTable.IMapIterator itor = this.elements.entries();
        for (int i = 0; i < nnz; ++i) {
            if (itor.next() == -1) {
                throw new IllegalStateException("itor.next() returns -1 where i=" + i);
            }
            long k = itor.getKey();
            rows[i] = Primitives.getHigh(k);
            cols[i] = Primitives.getLow(k);
            data[i] = itor.getValue();
        }
        return MatrixUtils.coo2csc(rows, cols, data, this.numRows, this.numColumns, true);
    }

    @Override
    public DoKMatrixBuilder builder() {
        return new DoKMatrixBuilder(this.elements.size());
    }

    @Nonnegative
    private static long index(@Nonnegative int row, @Nonnegative int col) {
        return Primitives.toLong(row, col);
    }

    @Override
    public double get(@Nonnegative int row, @Nonnegative int col, double defaultValue) {
        return this.get(row, col, (float)defaultValue);
    }

    @Override
    public void set(@Nonnegative int row, @Nonnegative int col, double value) {
        this.set(row, col, (float)value);
    }

    @Override
    public double getAndSet(@Nonnegative int row, @Nonnegative int col, double value) {
        return this.getAndSet(row, col, (float)value);
    }
}

