/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.utils.collections.arrays;

import java.util.Arrays;
import javax.annotation.Nonnull;
import matrix4j.utils.collections.arrays.FloatArray;
import matrix4j.utils.lang.ArrayUtils;
import matrix4j.utils.lang.Preconditions;
import matrix4j.vector.VectorProcedure;

public final class SparseFloatArray
implements FloatArray {
    private static final long serialVersionUID = -2814248784231540118L;
    private int[] mKeys;
    private float[] mValues;
    private int mSize;

    public SparseFloatArray() {
        this(10);
    }

    public SparseFloatArray(int initialCapacity) {
        this.mKeys = new int[initialCapacity];
        this.mValues = new float[initialCapacity];
        this.mSize = 0;
    }

    private SparseFloatArray(@Nonnull int[] mKeys, @Nonnull float[] mValues, int mSize) {
        this.mKeys = mKeys;
        this.mValues = mValues;
        this.mSize = mSize;
    }

    public SparseFloatArray deepCopy() {
        int[] newKeys = new int[this.mSize];
        float[] newValues = new float[this.mSize];
        System.arraycopy(this.mKeys, 0, newKeys, 0, this.mSize);
        System.arraycopy(this.mValues, 0, newValues, 0, this.mSize);
        return new SparseFloatArray(newKeys, newValues, this.mSize);
    }

    @Override
    public float get(int key) {
        return this.get(key, 0.0f);
    }

    @Override
    public float get(int key, float valueIfKeyNotFound) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i < 0) {
            return valueIfKeyNotFound;
        }
        return this.mValues[i];
    }

    public void delete(int key) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            this.removeAt(i);
        }
    }

    public void removeAt(int index) {
        System.arraycopy(this.mKeys, index + 1, this.mKeys, index, this.mSize - (index + 1));
        System.arraycopy(this.mValues, index + 1, this.mValues, index, this.mSize - (index + 1));
        --this.mSize;
    }

    @Override
    public void put(int key, float value) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            this.mKeys = ArrayUtils.insert(this.mKeys, this.mSize, i ^= 0xFFFFFFFF, key);
            this.mValues = ArrayUtils.insert(this.mValues, this.mSize, i, value);
            ++this.mSize;
        }
    }

    public void increment(int key, float value) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            int n = i;
            this.mValues[n] = this.mValues[n] + value;
        } else {
            this.mKeys = ArrayUtils.insert(this.mKeys, this.mSize, i ^= 0xFFFFFFFF, key);
            this.mValues = ArrayUtils.insert(this.mValues, this.mSize, i, value);
            ++this.mSize;
        }
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public int keyAt(int index) {
        return this.mKeys[index];
    }

    public float valueAt(int index) {
        return this.mValues[index];
    }

    public void setValueAt(int index, float value) {
        this.mValues[index] = value;
    }

    public int indexOfKey(int key) {
        return Arrays.binarySearch(this.mKeys, 0, this.mSize, key);
    }

    public int indexOfValue(float value) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void clear() {
        this.clear(true);
    }

    public void clear(boolean zeroFill) {
        this.mSize = 0;
        if (zeroFill) {
            Arrays.fill(this.mKeys, 0);
            Arrays.fill(this.mValues, 0.0f);
        }
    }

    public void append(int key, float value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        this.mKeys = ArrayUtils.append(this.mKeys, this.mSize, key);
        this.mValues = ArrayUtils.append(this.mValues, this.mSize, value);
        ++this.mSize;
    }

    @Override
    @Nonnull
    public float[] toArray() {
        return this.toArray(true);
    }

    @Override
    public float[] toArray(boolean copy) {
        if (this.mSize == 0) {
            return new float[0];
        }
        int last = this.mKeys[this.mSize - 1];
        float[] array = new float[last + 1];
        for (int i = 0; i < this.mSize; ++i) {
            int k = this.mKeys[i];
            float v = this.mValues[i];
            Preconditions.checkArgument(k >= 0, "Negative key is not allowed for toArray(): " + k);
            array[k] = v;
        }
        return array;
    }

    public void each(@Nonnull VectorProcedure procedure) {
        for (int i = 0; i < this.mSize; ++i) {
            int k = this.mKeys[i];
            float v = this.mValues[i];
            procedure.apply(k, v);
        }
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            int key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            float value = this.valueAt(i);
            buffer.append(value);
        }
        buffer.append('}');
        return buffer.toString();
    }
}

