/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.utils.collections.lists;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class DoubleArrayList
implements Serializable {
    private static final long serialVersionUID = -8155789759545975413L;
    public static final int DEFAULT_CAPACITY = 12;
    private double[] data;
    private int used;

    public DoubleArrayList() {
        this(12);
    }

    public DoubleArrayList(int size) {
        this.data = new double[size];
        this.used = 0;
    }

    public DoubleArrayList(@CheckForNull double[] initValues) {
        this.data = Objects.requireNonNull(initValues);
        this.used = initValues.length;
    }

    @Nonnull
    public DoubleArrayList add(double value) {
        if (this.used >= this.data.length) {
            this.expand(this.used + 1);
        }
        this.data[this.used++] = value;
        return this;
    }

    @Nonnull
    public DoubleArrayList add(@Nonnull double[] values) {
        int needs = this.used + values.length;
        if (needs >= this.data.length) {
            this.expand(needs);
        }
        System.arraycopy(values, 0, this.data, this.used, values.length);
        this.used = needs;
        return this;
    }

    private void expand(int minimumCapacity) {
        while (this.data.length < minimumCapacity) {
            int oldLen = this.data.length;
            int newLen = (int)Math.max((long)minimumCapacity, Math.min((long)oldLen * 2L, Integer.MAX_VALUE));
            double[] newArray = new double[newLen];
            System.arraycopy(this.data, 0, newArray, 0, oldLen);
            this.data = newArray;
        }
    }

    public double remove() {
        if (this.used == 0) {
            throw new NoSuchElementException("No elements to remove");
        }
        return this.data[--this.used];
    }

    public double remove(int index) {
        double ret;
        if (index >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.used) {
            ret = this.data[index];
            --this.used;
        } else {
            ret = this.data[index];
            System.arraycopy(this.data, index + 1, this.data, index, this.used - index - 1);
            --this.used;
        }
        return ret;
    }

    public void set(int index, double value) {
        if (index > this.used) {
            throw new IllegalArgumentException("Index MUST be less than \"size()\".");
        }
        if (index == this.used) {
            ++this.used;
        }
        this.data[index] = value;
    }

    public double get(int index) {
        if (index >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[index];
    }

    public double fastGet(int index) {
        return this.data[index];
    }

    public int size() {
        return this.used;
    }

    public boolean isEmpty() {
        return this.used == 0;
    }

    public void clear() {
        this.used = 0;
    }

    @Nonnull
    public double[] toArray() {
        return this.toArray(false);
    }

    @Nonnull
    public double[] toArray(boolean close) {
        double[] newArray = new double[this.used];
        System.arraycopy(this.data, 0, newArray, 0, this.used);
        if (close) {
            this.data = null;
        }
        return newArray;
    }

    public double[] array() {
        return this.data;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < this.used; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.data[i]);
        }
        buf.append(']');
        return buf.toString();
    }
}

