/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.utils.collections.maps;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import javax.annotation.Nonnull;
import matrix4j.utils.math.Primes;

public final class Long2DoubleOpenHashTable
implements Externalizable {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final float DEFAULT_GROW_FACTOR = 2.0f;
    private static final float SHRINK_FACTOR = 0.1f;
    private static final float GROW_FACTOR_AT_SHRINK = 1.7f;
    protected float _loadFactor;
    protected float _growFactor;
    protected int _used;
    protected int _freeEntries;
    protected int _growThreshold;
    protected int _shrinkThreshold;
    protected double _defaultReturnValue = 0.0;
    protected long[] _keys;
    protected double[] _values;
    protected byte[] _states;

    protected Long2DoubleOpenHashTable(int size, float loadFactor, float growFactor, boolean forcePrime) {
        if (size < 1) {
            throw new IllegalArgumentException();
        }
        this._loadFactor = loadFactor;
        this._growFactor = growFactor;
        int actualSize = forcePrime ? Primes.findLeastPrimeNumber(size) : size;
        this._keys = new long[actualSize];
        this._values = new double[actualSize];
        this._states = new byte[actualSize];
        this._used = 0;
        this._freeEntries = actualSize;
        this._growThreshold = Math.round((float)actualSize * this._loadFactor);
        this._shrinkThreshold = Math.round((float)actualSize * 0.1f);
    }

    public Long2DoubleOpenHashTable(int size, int loadFactor, int growFactor) {
        this(size, loadFactor, growFactor, true);
    }

    public Long2DoubleOpenHashTable(int size) {
        this(size, 0.75f, 2.0f, true);
    }

    public Long2DoubleOpenHashTable() {
        this._loadFactor = 0.75f;
        this._growFactor = 2.0f;
    }

    public void defaultReturnValue(double v) {
        this._defaultReturnValue = v;
    }

    public boolean containsKey(long key) {
        return this._findKey(key) >= 0;
    }

    public double get(long key) {
        return this.get(key, this._defaultReturnValue);
    }

    public double get(long key, double defaultValue) {
        int i = this._findKey(key);
        if (i == -1) {
            return defaultValue;
        }
        return this._values[i];
    }

    public double _get(int index) {
        if (index < 0) {
            return this._defaultReturnValue;
        }
        return this._values[index];
    }

    public double _set(int index, double value) {
        double old = this._values[index];
        this._values[index] = value;
        return old;
    }

    public double _remove(int index) {
        this._states[index] = 2;
        --this._used;
        return this._values[index];
    }

    public double put(long key, double value) {
        return this.put(key, value, this._defaultReturnValue);
    }

    public double put(long key, double value, double defaultValue) {
        byte state;
        long[] keys;
        block10: {
            int keyLength;
            int hash = Long2DoubleOpenHashTable.keyHash(key);
            int keyIdx = hash % (keyLength = this._keys.length);
            boolean expanded = this.preAddEntry(keyIdx);
            if (expanded) {
                keyLength = this._keys.length;
                keyIdx = hash % keyLength;
            }
            keys = this._keys;
            double[] values = this._values;
            byte[] states = this._states;
            state = states[keyIdx];
            if (state == 1) {
                if (keys[keyIdx] == key) {
                    double old = values[keyIdx];
                    values[keyIdx] = value;
                    return old;
                }
                int loopIndex = keyIdx;
                int decr = 1 + hash % (keyLength - 2);
                do {
                    if ((keyIdx -= decr) < 0) {
                        keyIdx += keyLength;
                    }
                    if (keyIdx == loopIndex) {
                        throw new IllegalStateException("Detected infinite loop where key=" + key + ", keyIdx=" + keyIdx);
                    }
                    state = states[keyIdx];
                    if (state == 0) break block10;
                } while (keys[keyIdx] != key);
                if (state == 1) {
                    double old = values[keyIdx];
                    values[keyIdx] = value;
                    return old;
                }
                assert (state == 2);
            }
        }
        keys[keyIdx] = key;
        values[keyIdx] = value;
        states[keyIdx] = 1;
        ++this._used;
        if (state == 0) {
            --this._freeEntries;
            if (this._freeEntries < this._shrinkThreshold) {
                int newCapacity = Math.max(keys.length, Math.round((float)this._used * 1.7f));
                this.ensureCapacity(newCapacity);
            }
        }
        return defaultValue;
    }

    protected boolean preAddEntry(int index) {
        if (this._used + 1 >= this._growThreshold) {
            int newCapacity = Math.round((float)this._keys.length * this._growFactor);
            this.ensureCapacity(newCapacity);
            return true;
        }
        return false;
    }

    public int _findKey(long key) {
        int startIndex;
        long[] keys = this._keys;
        byte[] states = this._states;
        int keyLength = keys.length;
        int hash = Long2DoubleOpenHashTable.keyHash(key);
        int decr = 1 + hash % (keyLength - 2);
        int keyIdx = startIndex = hash % keyLength;
        do {
            byte state;
            if ((state = states[keyIdx]) == 0) {
                return -1;
            }
            if (keys[keyIdx] == key) {
                if (state == 1) {
                    return keyIdx;
                }
                assert (state == 2);
                return -1;
            }
            if ((keyIdx -= decr) >= 0) continue;
            keyIdx += keyLength;
        } while (keyIdx != startIndex);
        throw new IllegalStateException("Detected infinite loop where key=" + key + ", keyIdx=" + keyIdx);
    }

    public double remove(long key) {
        int keyIdx = this._findKey(key);
        if (keyIdx == -1) {
            return this._defaultReturnValue;
        }
        double old = this._values[keyIdx];
        this._states[keyIdx] = 2;
        --this._used;
        return old;
    }

    public int size() {
        return this._used;
    }

    public void clear() {
        Arrays.fill(this._states, (byte)0);
        this._used = 0;
        this._freeEntries = this._states.length;
    }

    public IMapIterator entries() {
        return new MapIterator();
    }

    public String toString() {
        int len = this.size() * 10 + 2;
        StringBuilder buf = new StringBuilder(len);
        buf.append('{');
        IMapIterator i = this.entries();
        while (i.next() != -1) {
            buf.append(i.getKey());
            buf.append('=');
            buf.append(i.getValue());
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        buf.append('}');
        return buf.toString();
    }

    protected void ensureCapacity(int newCapacity) {
        int prime = Primes.findLeastPrimeNumber(newCapacity);
        this.rehash(prime);
    }

    private void rehash(int newCapacity) {
        long[] oldKeys = this._keys;
        double[] oldValues = this._values;
        byte[] oldStates = this._states;
        int oldCapacity = this._keys.length;
        long[] newkeys = new long[newCapacity];
        double[] newValues = new double[newCapacity];
        byte[] newStates = new byte[newCapacity];
        int used = 0;
        for (int i = 0; i < oldCapacity; ++i) {
            if (oldStates[i] != 1) continue;
            long k = oldKeys[i];
            double v = oldValues[i];
            int hash = Long2DoubleOpenHashTable.keyHash(k);
            int keyIdx = hash % newCapacity;
            if (newStates[keyIdx] == 1) {
                int decr = 1 + hash % (newCapacity - 2);
                int loopIndex = keyIdx;
                do {
                    if ((keyIdx -= decr) < 0) {
                        keyIdx += newCapacity;
                    }
                    if (keyIdx != loopIndex) continue;
                    throw new IllegalStateException("Detected infinite loop where key=" + k + ", keyIdx=" + keyIdx);
                } while (newStates[keyIdx] != 0);
            }
            newkeys[keyIdx] = k;
            newValues[keyIdx] = v;
            newStates[keyIdx] = 1;
            ++used;
        }
        this._keys = newkeys;
        this._values = newValues;
        this._states = newStates;
        this._used = used;
        this._freeEntries = newCapacity - used;
        this._growThreshold = Math.round((float)newCapacity * this._loadFactor);
        this._shrinkThreshold = Math.round((float)newCapacity * 0.1f);
    }

    private static int keyHash(long key) {
        return (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
    }

    @Override
    public void writeExternal(@Nonnull ObjectOutput out) throws IOException {
        out.writeFloat(this._loadFactor);
        out.writeFloat(this._growFactor);
        out.writeInt(this._used);
        out.writeDouble(this._defaultReturnValue);
        IMapIterator i = this.entries();
        while (i.next() != -1) {
            out.writeLong(i.getKey());
            out.writeDouble(i.getValue());
        }
    }

    @Override
    public void readExternal(@Nonnull ObjectInput in) throws IOException, ClassNotFoundException {
        this._loadFactor = in.readFloat();
        this._growFactor = in.readFloat();
        int used = in.readInt();
        this._defaultReturnValue = in.readDouble();
        int newCapacity = Primes.findLeastPrimeNumber(Math.round((float)used * 1.7f));
        long[] keys = new long[newCapacity];
        double[] values = new double[newCapacity];
        byte[] states = new byte[newCapacity];
        for (int i = 0; i < used; ++i) {
            long k = in.readLong();
            double v = in.readDouble();
            int hash = Long2DoubleOpenHashTable.keyHash(k);
            int keyIdx = hash % newCapacity;
            if (states[keyIdx] != 0) {
                int decr = 1 + hash % (newCapacity - 2);
                int loopIndex = keyIdx;
                do {
                    if ((keyIdx -= decr) < 0) {
                        keyIdx += newCapacity;
                    }
                    if (keyIdx != loopIndex) continue;
                    throw new IllegalStateException("Detected infinite loop where key=" + k + ", keyIdx=" + keyIdx);
                } while (states[keyIdx] != 0);
            }
            keys[keyIdx] = k;
            values[keyIdx] = v;
            states[keyIdx] = 1;
        }
        this._keys = keys;
        this._values = values;
        this._states = states;
        this._used = used;
        this._freeEntries = newCapacity - used;
        this._growThreshold = Math.round((float)newCapacity * this._loadFactor);
        this._shrinkThreshold = Math.round((float)newCapacity * 0.1f);
    }

    private final class MapIterator
    implements IMapIterator {
        int nextEntry = this.nextEntry(0);
        int lastEntry = -1;

        MapIterator() {
        }

        int nextEntry(int index) {
            while (index < Long2DoubleOpenHashTable.this._keys.length && Long2DoubleOpenHashTable.this._states[index] != 1) {
                ++index;
            }
            return index;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry < Long2DoubleOpenHashTable.this._keys.length;
        }

        @Override
        public int next() {
            int curEntry;
            if (!this.hasNext()) {
                return -1;
            }
            this.lastEntry = curEntry = this.nextEntry;
            this.nextEntry = this.nextEntry(curEntry + 1);
            return curEntry;
        }

        @Override
        public long getKey() {
            if (this.lastEntry == -1) {
                throw new IllegalStateException();
            }
            return Long2DoubleOpenHashTable.this._keys[this.lastEntry];
        }

        @Override
        public double getValue() {
            if (this.lastEntry == -1) {
                throw new IllegalStateException();
            }
            return Long2DoubleOpenHashTable.this._values[this.lastEntry];
        }
    }

    public static interface IMapIterator {
        public boolean hasNext();

        public int next();

        public long getKey();

        public double getValue();
    }
}

