/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.utils.lang;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matrix4j.utils.lang.Preconditions;

public final class ArrayUtils {
    public static final int INDEX_NOT_FOUND = -1;

    private ArrayUtils() {
    }

    @Nonnull
    public static double[] set(@Nonnull double[] src, int index, double value) {
        if (index >= src.length) {
            src = Arrays.copyOf(src, src.length * 2);
        }
        src[index] = value;
        return src;
    }

    @Nonnull
    public static <T> T[] set(@Nonnull T[] src, int index, T value) {
        if (index >= src.length) {
            src = Arrays.copyOf(src, src.length * 2);
        }
        src[index] = value;
        return src;
    }

    @Nonnull
    public static int[] sortedArraySet(@Nonnull int[] sorted, @Nonnegative int element) {
        int i = Arrays.binarySearch(sorted, element);
        if (i >= 0) {
            return sorted;
        }
        return ArrayUtils.insert(sorted, ~i, element);
    }

    public static boolean contains(@Nonnull int[] sorted, @Nonnegative int element) {
        int i = Arrays.binarySearch(sorted, element);
        return i >= 0;
    }

    @Nonnull
    public static float[] toArray(@Nonnull List<Float> lst) {
        int ndim = lst.size();
        float[] ary = new float[ndim];
        int i = 0;
        for (float f : lst) {
            ary[i++] = f;
        }
        return ary;
    }

    @Nonnull
    public static Integer[] toObject(@Nonnull int[] array) {
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @Nonnull
    public static List<Integer> toList(@Nonnull int[] array) {
        Integer[] v = ArrayUtils.toObject(array);
        return Arrays.asList(v);
    }

    @Nonnull
    public static Long[] toObject(@Nonnull long[] array) {
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @Nonnull
    public static List<Long> toList(@Nonnull long[] array) {
        Long[] v = ArrayUtils.toObject(array);
        return Arrays.asList(v);
    }

    @Nonnull
    public static Float[] toObject(@Nonnull float[] array) {
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    @Nonnull
    public static List<Float> toList(@Nonnull float[] array) {
        Float[] v = ArrayUtils.toObject(array);
        return Arrays.asList(v);
    }

    @Nonnull
    public static Double[] toObject(@Nonnull double[] array) {
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    @Nonnull
    public static List<Double> toList(@Nonnull double[] array) {
        Double[] v = ArrayUtils.toObject(array);
        return Arrays.asList(v);
    }

    @Nonnull
    public static <T> T[] shuffle(@Nonnull T[] array) {
        ArrayUtils.shuffle(array, array.length);
        return array;
    }

    @Nonnull
    public static <T> T[] shuffle(@Nonnull T[] array, Random rnd) {
        ArrayUtils.shuffle(array, array.length, rnd);
        return array;
    }

    @Nonnull
    public static <T> T[] shuffle(@Nonnull T[] array, int size) {
        Random rnd = new Random();
        ArrayUtils.shuffle(array, size, rnd);
        return array;
    }

    @Nonnull
    public static <T> T[] shuffle(@Nonnull T[] array, int size, @Nonnull Random rnd) {
        for (int i = size; i > 1; --i) {
            int randomPosition = rnd.nextInt(i);
            ArrayUtils.swap(array, i - 1, randomPosition);
        }
        return array;
    }

    @Nonnull
    public static int[] shuffle(@Nonnull int[] array, @Nonnull Random rnd) {
        for (int i = array.length; i > 1; --i) {
            int randomPosition = rnd.nextInt(i);
            ArrayUtils.swap(array, i - 1, randomPosition);
        }
        return array;
    }

    public static void swap(@Nonnull Object[] arr, int i, int j) {
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(@Nonnull int[] arr, int i, int j) {
        int tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(@Nonnull long[] arr, int i, int j) {
        long tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(@Nonnull float[] arr, int i, int j) {
        float tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void swap(@Nonnull double[] arr, int i, int j) {
        double tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    @Nullable
    public static Object[] subarray(@Nullable Object[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        int newSize = endIndexExclusive - startIndexInclusive;
        Class<?> type = array.getClass().getComponentType();
        if (newSize <= 0) {
            return (Object[])Array.newInstance(type, 0);
        }
        Object[] subarray = (Object[])Array.newInstance(type, newSize);
        System.arraycopy(array, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static int indexOf(@Nullable int[] array, int valueToFind, int startIndex, int endIndex) {
        if (array == null) {
            return -1;
        }
        int til = Math.min(endIndex, array.length);
        if (startIndex < 0 || startIndex > til) {
            throw new IllegalArgumentException("Illegal startIndex: " + startIndex);
        }
        for (int i = startIndex; i < til; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(@Nullable int[] array, int valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        return ArrayUtils.lastIndexOf(array, valueToFind, startIndex, array.length);
    }

    public static int lastIndexOf(@Nullable int[] array, int valueToFind, int startIndex, int endIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("startIndex out of bound: " + startIndex);
        }
        if (endIndex >= array.length) {
            throw new IllegalArgumentException("endIndex out of bound: " + endIndex);
        }
        for (int i = endIndex - 1; i >= startIndex; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int insertionPoint(@Nonnull int[] a, int key) {
        int pos = Arrays.binarySearch(a, key);
        if (pos < 0) {
            return ~pos;
        }
        return pos;
    }

    public static int insertionPoint(@Nonnull int[] a, int size, int key) {
        int pos = Arrays.binarySearch(a, 0, size, key);
        if (pos < 0) {
            return ~pos;
        }
        return pos;
    }

    @Nonnull
    public static byte[] copyOf(@Nonnull byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] copyOf(@Nonnull int[] src) {
        int len = src.length;
        int[] dest = new int[len];
        System.arraycopy(src, 0, dest, 0, len);
        return dest;
    }

    public static void copy(@Nonnull int[] src, @Nonnull int[] dest) {
        if (src.length != dest.length) {
            throw new IllegalArgumentException("src.legnth '" + src.length + "' != dest.length '" + dest.length + "'");
        }
        System.arraycopy(src, 0, dest, 0, src.length);
    }

    @Nonnull
    public static int[] append(@Nonnull int[] array, int element) {
        int size = array.length;
        int[] newArray = new int[size + 1];
        System.arraycopy(array, 0, newArray, 0, size);
        newArray[size] = element;
        return newArray;
    }

    @Nonnull
    public static int[] append(@Nonnull int[] array, int currentSize, int element) {
        if (currentSize + 1 > array.length) {
            int[] newArray = new int[currentSize * 2];
            System.arraycopy(array, 0, newArray, 0, currentSize);
            array = newArray;
        }
        array[currentSize] = element;
        return array;
    }

    @Nonnull
    public static float[] append(@Nonnull float[] array, int currentSize, float element) {
        if (currentSize + 1 > array.length) {
            float[] newArray = new float[currentSize * 2];
            System.arraycopy(array, 0, newArray, 0, currentSize);
            array = newArray;
        }
        array[currentSize] = element;
        return array;
    }

    @Nonnull
    public static double[] append(@Nonnull double[] array, int currentSize, double element) {
        if (currentSize + 1 > array.length) {
            double[] newArray = new double[currentSize * 2];
            System.arraycopy(array, 0, newArray, 0, currentSize);
            array = newArray;
        }
        array[currentSize] = element;
        return array;
    }

    @Nonnull
    public static int[] concat(@Nonnegative int[] array1, int ... array2) {
        int[] joinedArray = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    @Nonnull
    public static int[] concat(@Nonnegative int[] array1, @Nonnegative int[] array2, int offset, int length) {
        int[] joinedArray = new int[array1.length + length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, offset, joinedArray, array1.length, length);
        return joinedArray;
    }

    @Nonnull
    public static int[] concat(@Nonnegative int[] array1, int offset1, int length1, @Nonnegative int[] array2, int offset2, int length2) {
        int[] joinedArray = new int[length1 + length2];
        System.arraycopy(array1, offset1, joinedArray, 0, length1);
        System.arraycopy(array2, offset2, joinedArray, length1, length2);
        return joinedArray;
    }

    @Nonnull
    public static int[] insert(@Nonnull int[] array, int index, int element) {
        int size = array.length;
        if (index > size) {
            throw new IllegalArgumentException(String.format("index should be less than or equals to array.length: index=%d, array.length=%d", index, array.length));
        }
        int[] newArray = new int[size + 1];
        System.arraycopy(array, 0, newArray, 0, Math.min(index, size));
        newArray[index] = element;
        if (index != size) {
            System.arraycopy(array, index, newArray, index + 1, size - index);
        }
        return newArray;
    }

    @Nonnull
    public static int[] insert(@Nonnull int[] array, int currentSize, int index, int element) {
        if (currentSize + 1 <= array.length) {
            System.arraycopy(array, index, array, index + 1, currentSize - index);
            array[index] = element;
            return array;
        }
        int[] newArray = new int[currentSize * 2];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    @Nonnull
    public static float[] insert(@Nonnull float[] array, int currentSize, int index, float element) {
        if (currentSize + 1 <= array.length) {
            System.arraycopy(array, index, array, index + 1, currentSize - index);
            array[index] = element;
            return array;
        }
        float[] newArray = new float[currentSize * 2];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    @Nonnull
    public static double[] insert(@Nonnull double[] array, int currentSize, int index, double element) {
        if (currentSize + 1 <= array.length) {
            System.arraycopy(array, index, array, index + 1, currentSize - index);
            array[index] = element;
            return array;
        }
        double[] newArray = new double[currentSize * 2];
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = element;
        System.arraycopy(array, index, newArray, index + 1, array.length - index);
        return newArray;
    }

    public static void clearRange(@Nonnull int[] array, @Nonnegative int fromIndex, @Nonnegative int toIndex, int fillVal) {
        int size = array.length;
        if (fromIndex < 0 || fromIndex >= size || toIndex > size || toIndex < fromIndex) {
            throw new IllegalArgumentException(String.format("fromIndex: %d, toIndex: %d, array.length=%d", fromIndex, toIndex, size));
        }
        System.arraycopy(array, toIndex, array, fromIndex, array.length - toIndex);
        Arrays.fill(array, toIndex, array.length, fillVal);
    }

    public static boolean equals(@Nonnull float[] array, float value) {
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (array[i] == value) continue;
            return false;
        }
        return true;
    }

    public static boolean almostEquals(@Nonnull float[] array, float expected) {
        return ArrayUtils.equals(array, expected, 1.0E-15f);
    }

    public static boolean equals(@Nonnull float[] array, float expected, float delta) {
        for (float actual : array) {
            if (!(Math.abs(expected - actual) > delta)) continue;
            return false;
        }
        return true;
    }

    public static void copy(@Nonnull float[] src, @Nonnull double[] dst) {
        int size = Math.min(src.length, dst.length);
        for (int i = 0; i < size; ++i) {
            dst[i] = src[i];
        }
    }

    public static void sort(long[] arr, double[] brr) {
        ArrayUtils.sort(arr, brr, arr.length);
    }

    public static void sort(long[] arr, double[] brr, int n) {
        int NSTACK = 64;
        int M = 7;
        int[] istack = new int[64];
        int jstack = -1;
        int l = 0;
        int ir = n - 1;
        while (true) {
            int i;
            double b;
            long a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    for (i = j - 1; i >= l && arr[i] > a; --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            ArrayUtils.swap(arr, k, l + 1);
            ArrayUtils.swap(brr, k, l + 1);
            if (arr[l] > arr[ir]) {
                ArrayUtils.swap(arr, l, ir);
                ArrayUtils.swap(brr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                ArrayUtils.swap(arr, l + 1, ir);
                ArrayUtils.swap(brr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                ArrayUtils.swap(arr, l, l + 1);
                ArrayUtils.swap(brr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                ArrayUtils.swap(arr, i, j);
                ArrayUtils.swap(brr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(@Nonnull int[] arr, @Nonnull int[] brr, @Nonnull double[] crr) {
        ArrayUtils.sort(arr, brr, crr, arr.length);
    }

    public static void sort(@Nonnull int[] arr, @Nonnull int[] brr, @Nonnull double[] crr, int n) {
        Preconditions.checkArgument(arr.length >= n);
        Preconditions.checkArgument(brr.length >= n);
        Preconditions.checkArgument(crr.length >= n);
        int NSTACK = 64;
        int M = 7;
        int[] istack = new int[64];
        int jstack = -1;
        int l = 0;
        int ir = n - 1;
        while (true) {
            int i;
            double c;
            int b;
            int a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    c = crr[j];
                    for (i = j - 1; i >= l && arr[i] > a; --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                        crr[i + 1] = crr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                    crr[i + 1] = c;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            ArrayUtils.swap(arr, k, l + 1);
            ArrayUtils.swap(brr, k, l + 1);
            ArrayUtils.swap(crr, k, l + 1);
            if (arr[l] > arr[ir]) {
                ArrayUtils.swap(arr, l, ir);
                ArrayUtils.swap(brr, l, ir);
                ArrayUtils.swap(crr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                ArrayUtils.swap(arr, l + 1, ir);
                ArrayUtils.swap(brr, l + 1, ir);
                ArrayUtils.swap(crr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                ArrayUtils.swap(arr, l, l + 1);
                ArrayUtils.swap(brr, l, l + 1);
                ArrayUtils.swap(crr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            c = crr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                ArrayUtils.swap(arr, i, j);
                ArrayUtils.swap(brr, i, j);
                ArrayUtils.swap(crr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            crr[l + 1] = crr[j];
            crr[j] = c;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(@Nonnull int[] arr, @Nonnull int[] brr, @Nonnull float[] crr) {
        ArrayUtils.sort(arr, brr, crr, arr.length);
    }

    public static void sort(@Nonnull int[] arr, @Nonnull int[] brr, @Nonnull float[] crr, int n) {
        Preconditions.checkArgument(arr.length >= n);
        Preconditions.checkArgument(brr.length >= n);
        Preconditions.checkArgument(crr.length >= n);
        int NSTACK = 64;
        int M = 7;
        int[] istack = new int[64];
        int jstack = -1;
        int l = 0;
        int ir = n - 1;
        while (true) {
            int i;
            float c;
            int b;
            int a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    b = brr[j];
                    c = crr[j];
                    for (i = j - 1; i >= l && arr[i] > a; --i) {
                        arr[i + 1] = arr[i];
                        brr[i + 1] = brr[i];
                        crr[i + 1] = crr[i];
                    }
                    arr[i + 1] = a;
                    brr[i + 1] = b;
                    crr[i + 1] = c;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            ArrayUtils.swap(arr, k, l + 1);
            ArrayUtils.swap(brr, k, l + 1);
            ArrayUtils.swap(crr, k, l + 1);
            if (arr[l] > arr[ir]) {
                ArrayUtils.swap(arr, l, ir);
                ArrayUtils.swap(brr, l, ir);
                ArrayUtils.swap(crr, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                ArrayUtils.swap(arr, l + 1, ir);
                ArrayUtils.swap(brr, l + 1, ir);
                ArrayUtils.swap(crr, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                ArrayUtils.swap(arr, l, l + 1);
                ArrayUtils.swap(brr, l, l + 1);
                ArrayUtils.swap(crr, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            b = brr[l + 1];
            c = crr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                ArrayUtils.swap(arr, i, j);
                ArrayUtils.swap(brr, i, j);
                ArrayUtils.swap(crr, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            brr[l + 1] = brr[j];
            brr[j] = b;
            crr[l + 1] = crr[j];
            crr[j] = c;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static int count(@Nonnull int[] values, int valueToFind) {
        int cnt = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != valueToFind) continue;
            ++cnt;
        }
        return cnt;
    }

    @Nonnull
    public static float[] newFloatArray(@Nonnegative int size, float filledValue) {
        float[] a = new float[size];
        Arrays.fill(a, filledValue);
        return a;
    }
}

