/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.utils.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T, E extends Throwable> T checkNotNull(@Nullable T reference, @Nonnull Class<E> clazz) throws E {
        if (reference == null) {
            Throwable throwable;
            try {
                throwable = (Throwable)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Failed to instantiate a class: " + clazz.getName(), e);
            }
            throw throwable;
        }
        return reference;
    }

    public static <T, E extends Throwable> T checkNotNull(@Nullable T reference, @Nonnull String errorMessage, @Nonnull Class<E> clazz) throws E {
        if (reference == null) {
            Throwable throwable;
            try {
                Constructor<E> constructor = clazz.getConstructor(String.class);
                throwable = (Throwable)constructor.newInstance(errorMessage);
            }
            catch (NoSuchMethodException | SecurityException e1) {
                throw new IllegalStateException("Failed to get a Constructor(String): " + clazz.getName(), e1);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e2) {
                throw new IllegalStateException("Failed to instantiate a class: " + clazz.getName(), e2);
            }
            throw throwable;
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, @Nullable Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static <E extends Throwable> void checkArgument(boolean expression, @Nonnull Class<E> clazz) throws E {
        if (!expression) {
            Throwable throwable;
            try {
                throwable = (Throwable)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Failed to instantiate a class: " + clazz.getName(), e);
            }
            throw throwable;
        }
    }

    public static <E extends Throwable> void checkArgument(boolean expression, @Nonnull Class<E> clazz, @Nullable Object errorMessage) throws E {
        if (!expression) {
            Throwable throwable;
            Constructor<E> constructor;
            try {
                constructor = clazz.getConstructor(String.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalStateException("Failed to get a constructor of " + clazz.getName(), e);
            }
            try {
                throwable = (Throwable)constructor.newInstance(errorMessage);
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to instantiate a class: " + clazz.getName(), e);
            }
            throw throwable;
        }
    }

    public static void checkArgument(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }
}

