/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.vector;

import javax.annotation.Nonnegative;
import matrix4j.vector.Vector;

public abstract class AbstractVector
implements Vector {
    @Override
    public double get(@Nonnegative int index) {
        return this.get(index, 0.0);
    }

    @Override
    public float get(@Nonnegative int index, float defaultValue) {
        return (float)this.get(index, (double)defaultValue);
    }

    @Override
    public void set(@Nonnegative int index, float value) {
        this.set(index, (double)value);
    }

    @Override
    public void decr(int index, double delta) {
        this.incr(index, -delta);
    }

    protected static final void checkIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Invalid index " + index);
        }
    }

    protected static final void checkIndex(int index, int size) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds " + size);
        }
    }
}

