/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.vector;

import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.vector.AbstractVector;
import matrix4j.vector.VectorProcedure;

public final class DenseFloatVector
extends AbstractVector {
    @Nonnull
    private final float[] values;
    private final int size;

    public DenseFloatVector(@Nonnegative int size) {
        this.values = new float[size];
        this.size = size;
    }

    public DenseFloatVector(@Nonnull float[] values) {
        this.values = values;
        this.size = values.length;
    }

    @Override
    public float get(@Nonnegative int index, float defaultValue) {
        DenseFloatVector.checkIndex(index);
        if (index >= this.size) {
            return defaultValue;
        }
        return this.values[index];
    }

    @Override
    public double get(@Nonnegative int index, double defaultValue) {
        DenseFloatVector.checkIndex(index);
        if (index >= this.size) {
            return defaultValue;
        }
        return this.values[index];
    }

    @Override
    public void set(@Nonnegative int index, float value) {
        DenseFloatVector.checkIndex(index, this.size);
        this.values[index] = value;
    }

    @Override
    public void set(@Nonnegative int index, double value) {
        DenseFloatVector.checkIndex(index, this.size);
        this.values[index] = (float)value;
    }

    @Override
    public void incr(@Nonnegative int index, double delta) {
        DenseFloatVector.checkIndex(index, this.size);
        int n = index;
        this.values[n] = (float)((double)this.values[n] + delta);
    }

    @Override
    public void each(@Nonnull VectorProcedure procedure) {
        for (int i = 0; i < this.values.length; ++i) {
            procedure.apply(i, this.values[i]);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, 0.0f);
    }

    @Override
    public double[] toArray() {
        throw new UnsupportedOperationException();
    }
}

