/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.vector;

import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.vector.AbstractVector;
import matrix4j.vector.VectorProcedure;

public final class DenseVector
extends AbstractVector {
    @Nonnull
    private final double[] values;
    private final int size;

    public DenseVector(@Nonnegative int size) {
        this.values = new double[size];
        this.size = size;
    }

    public DenseVector(@Nonnull double[] values) {
        this.values = values;
        this.size = values.length;
    }

    @Override
    public double get(@Nonnegative int index, double defaultValue) {
        DenseVector.checkIndex(index);
        if (index >= this.size) {
            return defaultValue;
        }
        return this.values[index];
    }

    @Override
    public void set(@Nonnegative int index, double value) {
        DenseVector.checkIndex(index, this.size);
        this.values[index] = value;
    }

    @Override
    public void incr(@Nonnegative int index, double delta) {
        DenseVector.checkIndex(index, this.size);
        int n = index;
        this.values[n] = this.values[n] + delta;
    }

    @Override
    public void each(@Nonnull VectorProcedure procedure) {
        for (int i = 0; i < this.values.length; ++i) {
            procedure.apply(i, this.values[i]);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, 0.0);
    }

    @Override
    public double[] toArray() {
        return this.values;
    }
}

