/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.vector;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.utils.collections.arrays.SparseFloatArray;
import matrix4j.vector.AbstractVector;
import matrix4j.vector.VectorProcedure;

public final class SparseFloatVector
extends AbstractVector {
    @Nonnull
    private final SparseFloatArray values;

    public SparseFloatVector() {
        this.values = new SparseFloatArray();
    }

    public SparseFloatVector(@Nonnull SparseFloatArray values) {
        this.values = values;
    }

    @Override
    public float get(@Nonnegative int index, float defaultValue) {
        return this.values.get(index, defaultValue);
    }

    @Override
    public double get(@Nonnegative int index, double defaultValue) {
        return this.values.get(index, (float)defaultValue);
    }

    @Override
    public void set(@Nonnegative int index, float value) {
        this.values.put(index, value);
    }

    @Override
    public void set(@Nonnegative int index, double value) {
        this.values.put(index, (float)value);
    }

    @Override
    public void incr(@Nonnegative int index, double delta) {
        this.values.increment(index, (float)delta);
    }

    @Override
    public void each(@Nonnull VectorProcedure procedure) {
        this.values.each(procedure);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public double[] toArray() {
        throw new UnsupportedOperationException();
    }
}

