/*
 * Decompiled with CFR 0.152.
 */
package matrix4j.vector;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import matrix4j.utils.collections.arrays.SparseDoubleArray;
import matrix4j.vector.AbstractVector;
import matrix4j.vector.VectorProcedure;

public final class SparseVector
extends AbstractVector {
    @Nonnull
    private final SparseDoubleArray values;

    public SparseVector() {
        this.values = new SparseDoubleArray();
    }

    public SparseVector(@Nonnull SparseDoubleArray values) {
        this.values = values;
    }

    @Override
    public double get(@Nonnegative int index, double defaultValue) {
        return this.values.get(index, defaultValue);
    }

    @Override
    public void set(@Nonnegative int index, double value) {
        this.values.put(index, value);
    }

    @Override
    public void incr(@Nonnegative int index, double delta) {
        this.values.increment(index, delta);
    }

    @Override
    public void each(@Nonnull VectorProcedure procedure) {
        this.values.each(procedure);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public double[] toArray() {
        return this.values.toArray();
    }
}

