/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.data.schema;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.data.schema.HCatSchema;

public class HCatFieldSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    String fieldName = null;
    String comment = null;
    Type type = null;
    Category category = null;
    HCatSchema subSchema = null;
    Type mapKeyType = null;
    private String typeString = null;

    public boolean isComplex() {
        return this.category != Category.PRIMITIVE;
    }

    private HCatFieldSchema() {
    }

    public Type getType() {
        return this.type;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getName() {
        return this.fieldName;
    }

    public String getComment() {
        return this.comment;
    }

    public HCatFieldSchema(String fieldName, Type type, String comment) throws HCatException {
        HCatFieldSchema.assertTypeInCategory(type, Category.PRIMITIVE, fieldName);
        this.fieldName = fieldName;
        this.type = type;
        this.category = Category.PRIMITIVE;
        this.comment = comment;
    }

    public HCatFieldSchema(String fieldName, Type type, HCatSchema subSchema, String comment) throws HCatException {
        HCatFieldSchema.assertTypeNotInCategory(type, Category.PRIMITIVE);
        HCatFieldSchema.assertTypeNotInCategory(type, Category.MAP);
        this.fieldName = fieldName;
        this.type = type;
        this.category = Category.fromType(type);
        this.subSchema = subSchema;
        if (type == Type.ARRAY) {
            this.subSchema.get(0).setName(null);
        }
        this.comment = comment;
    }

    private void setName(String name) {
        this.fieldName = name;
    }

    public HCatFieldSchema(String fieldName, Type type, Type mapKeyType, HCatSchema mapValueSchema, String comment) throws HCatException {
        HCatFieldSchema.assertTypeInCategory(type, Category.MAP, fieldName);
        HCatFieldSchema.assertTypeInCategory(mapKeyType, Category.PRIMITIVE, fieldName);
        this.fieldName = fieldName;
        this.type = Type.MAP;
        this.category = Category.MAP;
        this.mapKeyType = mapKeyType;
        this.subSchema = mapValueSchema;
        this.subSchema.get(0).setName(null);
        this.comment = comment;
    }

    public HCatSchema getStructSubSchema() throws HCatException {
        HCatFieldSchema.assertTypeInCategory(this.type, Category.STRUCT, this.fieldName);
        return this.subSchema;
    }

    public HCatSchema getArrayElementSchema() throws HCatException {
        HCatFieldSchema.assertTypeInCategory(this.type, Category.ARRAY, this.fieldName);
        return this.subSchema;
    }

    public Type getMapKeyType() throws HCatException {
        HCatFieldSchema.assertTypeInCategory(this.type, Category.MAP, this.fieldName);
        return this.mapKeyType;
    }

    public HCatSchema getMapValueSchema() throws HCatException {
        HCatFieldSchema.assertTypeInCategory(this.type, Category.MAP, this.fieldName);
        return this.subSchema;
    }

    private static void assertTypeInCategory(Type type, Category category, String fieldName) throws HCatException {
        Category typeCategory = Category.fromType(type);
        if (typeCategory != category) {
            throw new HCatException("Type category mismatch. Expected " + (Object)((Object)category) + " but type " + (Object)((Object)type) + " in category " + (Object)((Object)typeCategory) + " (field " + fieldName + ")");
        }
    }

    private static void assertTypeNotInCategory(Type type, Category category) throws HCatException {
        Category typeCategory = Category.fromType(type);
        if (typeCategory == category) {
            throw new HCatException("Type category mismatch. Expected type " + (Object)((Object)type) + " not in category " + (Object)((Object)category) + " but was so.");
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("fieldName", (Object)this.fieldName).append("comment", (Object)this.comment).append("type", (Object)this.getTypeString()).append("category", (Object)this.category).toString();
    }

    public String getTypeString() {
        if (this.typeString != null) {
            return this.typeString;
        }
        StringBuilder sb = new StringBuilder();
        if (Category.PRIMITIVE == this.category) {
            sb.append((Object)this.type);
        } else if (Category.STRUCT == this.category) {
            sb.append("struct<");
            sb.append(this.subSchema.getSchemaAsTypeString());
            sb.append(">");
        } else if (Category.ARRAY == this.category) {
            sb.append("array<");
            sb.append(this.subSchema.getSchemaAsTypeString());
            sb.append(">");
        } else if (Category.MAP == this.category) {
            sb.append("map<");
            sb.append((Object)this.mapKeyType);
            sb.append(",");
            sb.append(this.subSchema.getSchemaAsTypeString());
            sb.append(">");
        }
        this.typeString = sb.toString().toLowerCase();
        return this.typeString;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HCatFieldSchema)) {
            return false;
        }
        HCatFieldSchema other = (HCatFieldSchema)obj;
        if (this.category != other.category) {
            return false;
        }
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        return !(this.getTypeString() == null ? other.getTypeString() != null : !this.getTypeString().equals(other.getTypeString()));
    }

    public static enum Category {
        PRIMITIVE,
        ARRAY,
        MAP,
        STRUCT;


        public static Category fromType(Type type) {
            if (Type.ARRAY == type) {
                return ARRAY;
            }
            if (Type.STRUCT == type) {
                return STRUCT;
            }
            if (Type.MAP == type) {
                return MAP;
            }
            return PRIMITIVE;
        }
    }

    public static enum Type {
        INT,
        TINYINT,
        SMALLINT,
        BIGINT,
        BOOLEAN,
        FLOAT,
        DOUBLE,
        STRING,
        ARRAY,
        MAP,
        STRUCT,
        BINARY;

    }
}

