/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart.hhmm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.analysis.cn.smart.AnalyzerProfile;
import org.apache.lucene.analysis.cn.smart.Utility;
import org.apache.lucene.analysis.cn.smart.hhmm.AbstractDictionary;

class WordDictionary
extends AbstractDictionary {
    private static WordDictionary singleInstance;
    public static final int PRIME_INDEX_LENGTH = 12071;
    private short[] wordIndexTable;
    private char[] charIndexTable;
    private char[][][] wordItem_charArrayTable;
    private int[][] wordItem_frequencyTable;

    private WordDictionary() {
    }

    public static synchronized WordDictionary getInstance() {
        if (singleInstance == null) {
            singleInstance = new WordDictionary();
            try {
                singleInstance.load();
            }
            catch (IOException e) {
                String wordDictRoot = AnalyzerProfile.ANALYSIS_DATA_DIR;
                singleInstance.load(wordDictRoot);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return singleInstance;
    }

    public void load(String dctFileRoot) {
        String dctFilePath = dctFileRoot + "/coredict.dct";
        Path serialObj = Paths.get(dctFileRoot + "/coredict.mem", new String[0]);
        if (!Files.exists(serialObj, new LinkOption[0]) || !this.loadFromObj(serialObj)) {
            try {
                this.wordIndexTable = new short[12071];
                this.charIndexTable = new char[12071];
                for (int i = 0; i < 12071; ++i) {
                    this.charIndexTable[i] = '\u0000';
                    this.wordIndexTable[i] = -1;
                }
                this.wordItem_charArrayTable = new char[8178][][];
                this.wordItem_frequencyTable = new int[8178][];
                this.loadMainDataFromFile(dctFilePath);
                this.expandDelimiterData();
                this.mergeSameWords();
                this.sortEachItems();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            this.saveToObj(serialObj);
        }
    }

    public void load() throws IOException, ClassNotFoundException {
        InputStream input = this.getClass().getResourceAsStream("coredict.mem");
        this.loadFromObjectInputStream(input);
    }

    private boolean loadFromObj(Path serialObj) {
        try {
            this.loadFromObjectInputStream(Files.newInputStream(serialObj, new OpenOption[0]));
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadFromObjectInputStream(InputStream serialObjectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream input = new ObjectInputStream(serialObjectInputStream);
        this.wordIndexTable = (short[])input.readObject();
        this.charIndexTable = (char[])input.readObject();
        this.wordItem_charArrayTable = (char[][][])input.readObject();
        this.wordItem_frequencyTable = (int[][])input.readObject();
        input.close();
    }

    private void saveToObj(Path serialObj) {
        try {
            ObjectOutputStream output = new ObjectOutputStream(Files.newOutputStream(serialObj, new OpenOption[0]));
            output.writeObject(this.wordIndexTable);
            output.writeObject(this.charIndexTable);
            output.writeObject(this.wordItem_charArrayTable);
            output.writeObject(this.wordItem_frequencyTable);
            output.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int loadMainDataFromFile(String dctFilePath) throws IOException {
        int total = 0;
        int[] buffer = new int[3];
        byte[] intBuffer = new byte[4];
        DataInputStream dctFile = new DataInputStream(Files.newInputStream(Paths.get(dctFilePath, new String[0]), new OpenOption[0]));
        for (int i = 1410; i < 8178; ++i) {
            dctFile.read(intBuffer);
            int cnt = ByteBuffer.wrap(intBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
            if (cnt <= 0) {
                this.wordItem_charArrayTable[i] = null;
                this.wordItem_frequencyTable[i] = null;
                continue;
            }
            this.wordItem_charArrayTable[i] = new char[cnt][];
            this.wordItem_frequencyTable[i] = new int[cnt];
            total += cnt;
            for (int j = 0; j < cnt; ++j) {
                dctFile.read(intBuffer);
                buffer[0] = ByteBuffer.wrap(intBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
                dctFile.read(intBuffer);
                buffer[1] = ByteBuffer.wrap(intBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
                dctFile.read(intBuffer);
                buffer[2] = ByteBuffer.wrap(intBuffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
                this.wordItem_frequencyTable[i][j] = buffer[0];
                int length = buffer[1];
                if (length > 0) {
                    byte[] lchBuffer = new byte[length];
                    dctFile.read(lchBuffer);
                    String tmpword = new String(lchBuffer, "GB2312");
                    this.wordItem_charArrayTable[i][j] = tmpword.toCharArray();
                    continue;
                }
                this.wordItem_charArrayTable[i][j] = null;
            }
            String str = this.getCCByGB2312Id(i);
            this.setTableIndex(str.charAt(0), i);
        }
        dctFile.close();
        return total;
    }

    private void expandDelimiterData() {
        int delimiterIndex = 5165;
        int i = 0;
        while (i < this.wordItem_charArrayTable[delimiterIndex].length) {
            int k;
            char c = this.wordItem_charArrayTable[delimiterIndex][i][0];
            short j = this.getGB2312Id(c);
            if (this.wordItem_charArrayTable[j] != null) continue;
            for (k = i; k < this.wordItem_charArrayTable[delimiterIndex].length && this.wordItem_charArrayTable[delimiterIndex][k][0] == c; ++k) {
            }
            int cnt = k - i;
            if (cnt != 0) {
                this.wordItem_charArrayTable[j] = new char[cnt][];
                this.wordItem_frequencyTable[j] = new int[cnt];
            }
            k = 0;
            while (k < cnt) {
                this.wordItem_frequencyTable[j][k] = this.wordItem_frequencyTable[delimiterIndex][i];
                this.wordItem_charArrayTable[j][k] = new char[this.wordItem_charArrayTable[delimiterIndex][i].length - 1];
                System.arraycopy(this.wordItem_charArrayTable[delimiterIndex][i], 1, this.wordItem_charArrayTable[j][k], 0, this.wordItem_charArrayTable[j][k].length);
                ++k;
                ++i;
            }
            this.setTableIndex(c, j);
        }
        this.wordItem_charArrayTable[delimiterIndex] = null;
        this.wordItem_frequencyTable[delimiterIndex] = null;
    }

    private void mergeSameWords() {
        for (int i = 0; i < 8178; ++i) {
            if (this.wordItem_charArrayTable[i] == null) continue;
            int len = 1;
            for (int j = 1; j < this.wordItem_charArrayTable[i].length; ++j) {
                if (Utility.compareArray(this.wordItem_charArrayTable[i][j], 0, this.wordItem_charArrayTable[i][j - 1], 0) == 0) continue;
                ++len;
            }
            if (len >= this.wordItem_charArrayTable[i].length) continue;
            char[][] tempArray = new char[len][];
            int[] tempFreq = new int[len];
            int k = 0;
            tempArray[0] = this.wordItem_charArrayTable[i][0];
            tempFreq[0] = this.wordItem_frequencyTable[i][0];
            for (int j = 1; j < this.wordItem_charArrayTable[i].length; ++j) {
                if (Utility.compareArray(this.wordItem_charArrayTable[i][j], 0, tempArray[k], 0) != 0) {
                    tempArray[++k] = this.wordItem_charArrayTable[i][j];
                    tempFreq[k] = this.wordItem_frequencyTable[i][j];
                    continue;
                }
                int n = k;
                tempFreq[n] = tempFreq[n] + this.wordItem_frequencyTable[i][j];
            }
            this.wordItem_charArrayTable[i] = tempArray;
            this.wordItem_frequencyTable[i] = tempFreq;
        }
    }

    private void sortEachItems() {
        for (int i = 0; i < this.wordItem_charArrayTable.length; ++i) {
            if (this.wordItem_charArrayTable[i] == null || this.wordItem_charArrayTable[i].length <= 1) continue;
            for (int j = 0; j < this.wordItem_charArrayTable[i].length - 1; ++j) {
                for (int j2 = j + 1; j2 < this.wordItem_charArrayTable[i].length; ++j2) {
                    if (Utility.compareArray(this.wordItem_charArrayTable[i][j], 0, this.wordItem_charArrayTable[i][j2], 0) <= 0) continue;
                    char[] tmpArray = this.wordItem_charArrayTable[i][j];
                    int tmpFreq = this.wordItem_frequencyTable[i][j];
                    this.wordItem_charArrayTable[i][j] = this.wordItem_charArrayTable[i][j2];
                    this.wordItem_frequencyTable[i][j] = this.wordItem_frequencyTable[i][j2];
                    this.wordItem_charArrayTable[i][j2] = tmpArray;
                    this.wordItem_frequencyTable[i][j2] = tmpFreq;
                }
            }
        }
    }

    private boolean setTableIndex(char c, int j) {
        short index = this.getAvaliableTableIndex(c);
        if (index != -1) {
            this.charIndexTable[index] = c;
            this.wordIndexTable[index] = (short)j;
            return true;
        }
        return false;
    }

    private short getAvaliableTableIndex(char c) {
        int i;
        int hash1 = (int)(this.hash1(c) % 12071L);
        int hash2 = this.hash2(c) % 12071;
        if (hash1 < 0) {
            hash1 = 12071 + hash1;
        }
        if (hash2 < 0) {
            hash2 = 12071 + hash2;
        }
        int index = hash1;
        for (i = 1; this.charIndexTable[index] != '\u0000' && this.charIndexTable[index] != c && i < 12071; ++i) {
            index = (hash1 + i * hash2) % 12071;
        }
        if (i < 12071 && (this.charIndexTable[index] == '\u0000' || this.charIndexTable[index] == c)) {
            return (short)index;
        }
        return -1;
    }

    private short getWordItemTableIndex(char c) {
        int i;
        int hash1 = (int)(this.hash1(c) % 12071L);
        int hash2 = this.hash2(c) % 12071;
        if (hash1 < 0) {
            hash1 = 12071 + hash1;
        }
        if (hash2 < 0) {
            hash2 = 12071 + hash2;
        }
        int index = hash1;
        for (i = 1; this.charIndexTable[index] != '\u0000' && this.charIndexTable[index] != c && i < 12071; ++i) {
            index = (hash1 + i * hash2) % 12071;
        }
        if (i < 12071 && this.charIndexTable[index] == c) {
            return (short)index;
        }
        return -1;
    }

    private int findInTable(short knownHashIndex, char[] charArray) {
        if (charArray == null || charArray.length == 0) {
            return -1;
        }
        char[][] items = this.wordItem_charArrayTable[this.wordIndexTable[knownHashIndex]];
        int start2 = 0;
        int end = items.length - 1;
        int mid = (start2 + end) / 2;
        while (start2 <= end) {
            int cmpResult = Utility.compareArray(items[mid], 0, charArray, 1);
            if (cmpResult == 0) {
                return mid;
            }
            if (cmpResult < 0) {
                start2 = mid + 1;
            } else if (cmpResult > 0) {
                end = mid - 1;
            }
            mid = (start2 + end) / 2;
        }
        return -1;
    }

    public int getPrefixMatch(char[] charArray) {
        return this.getPrefixMatch(charArray, 0);
    }

    public int getPrefixMatch(char[] charArray, int knownStart) {
        short index = this.getWordItemTableIndex(charArray[0]);
        if (index == -1) {
            return -1;
        }
        char[][] items = this.wordItem_charArrayTable[this.wordIndexTable[index]];
        int start2 = knownStart;
        int end = items.length - 1;
        int mid = (start2 + end) / 2;
        while (start2 <= end) {
            int cmpResult = Utility.compareArrayByPrefix(charArray, 1, items[mid], 0);
            if (cmpResult == 0) {
                while (mid >= 0 && Utility.compareArrayByPrefix(charArray, 1, items[mid], 0) == 0) {
                    --mid;
                }
                return ++mid;
            }
            if (cmpResult < 0) {
                end = mid - 1;
            } else {
                start2 = mid + 1;
            }
            mid = (start2 + end) / 2;
        }
        return -1;
    }

    public int getFrequency(char[] charArray) {
        short hashIndex = this.getWordItemTableIndex(charArray[0]);
        if (hashIndex == -1) {
            return 0;
        }
        int itemIndex = this.findInTable(hashIndex, charArray);
        if (itemIndex != -1) {
            return this.wordItem_frequencyTable[this.wordIndexTable[hashIndex]][itemIndex];
        }
        return 0;
    }

    public boolean isEqual(char[] charArray, int itemIndex) {
        short hashIndex = this.getWordItemTableIndex(charArray[0]);
        return Utility.compareArray(charArray, 1, this.wordItem_charArrayTable[this.wordIndexTable[hashIndex]][itemIndex], 0) == 0;
    }
}

