/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.ja.dict.BinaryDictionary;
import org.apache.lucene.analysis.ja.dict.TokenInfoFST;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;

public final class TokenInfoDictionary
extends BinaryDictionary {
    public static final String FST_FILENAME_SUFFIX = "$fst.dat";
    private final TokenInfoFST fst;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TokenInfoDictionary() throws IOException {
        FST<Long> fst;
        block5: {
            InputStream is;
            block4: {
                is = null;
                fst = null;
                boolean success = false;
                try {
                    is = this.getResource(FST_FILENAME_SUFFIX);
                    is = new BufferedInputStream(is);
                    fst = new FST<Long>(new InputStreamDataInput(is), PositiveIntOutputs.getSingleton());
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(is);
                    } else {
                        IOUtils.closeWhileHandlingException(is);
                    }
                    throw throwable;
                }
                IOUtils.close(is);
                break block5;
            }
            IOUtils.closeWhileHandlingException(is);
        }
        this.fst = new TokenInfoFST(fst, true);
    }

    public TokenInfoFST getFST() {
        return this.fst;
    }

    public static TokenInfoDictionary getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        static final TokenInfoDictionary INSTANCE;

        private SingletonHolder() {
        }

        static {
            try {
                INSTANCE = new TokenInfoDictionary();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load TokenInfoDictionary.", ioe);
            }
        }
    }
}

