/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class TrimFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public TrimFilter(TokenStream in) {
        super(in);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] termBuffer = this.termAtt.buffer();
        int len = this.termAtt.length();
        if (len == 0) {
            return true;
        }
        int start2 = 0;
        int end = 0;
        for (start2 = 0; start2 < len && Character.isWhitespace(termBuffer[start2]); ++start2) {
        }
        for (end = len; end >= start2 && Character.isWhitespace(termBuffer[end - 1]); --end) {
        }
        if (start2 > 0 || end < len) {
            if (start2 < end) {
                this.termAtt.copyBuffer(termBuffer, start2, end - start2);
            } else {
                this.termAtt.setEmpty();
            }
        }
        return true;
    }
}

