/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeFactory;

@Deprecated
public final class Lucene43EdgeNGramTokenizer
extends Tokenizer {
    public static final Side DEFAULT_SIDE = Side.FRONT;
    public static final int DEFAULT_MAX_GRAM_SIZE = 1;
    public static final int DEFAULT_MIN_GRAM_SIZE = 1;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private int minGram;
    private int maxGram;
    private int gramSize;
    private Side side;
    private boolean started;
    private int inLen;
    private int charsRead;
    private String inStr;

    public Lucene43EdgeNGramTokenizer(Side side, int minGram, int maxGram) {
        this.init(side, minGram, maxGram);
    }

    public Lucene43EdgeNGramTokenizer(AttributeFactory factory, Side side, int minGram, int maxGram) {
        super(factory);
        this.init(side, minGram, maxGram);
    }

    public Lucene43EdgeNGramTokenizer(AttributeFactory factory, String sideLabel, int minGram, int maxGram) {
        this(factory, Side.getSide(sideLabel), minGram, maxGram);
    }

    public Lucene43EdgeNGramTokenizer(int minGram, int maxGram) {
        this(Side.FRONT, minGram, maxGram);
    }

    @Deprecated
    public Lucene43EdgeNGramTokenizer(String sideLabel, int minGram, int maxGram) {
        this(Side.getSide(sideLabel), minGram, maxGram);
    }

    public Lucene43EdgeNGramTokenizer(AttributeFactory factory, int minGram, int maxGram) {
        this(factory, Side.FRONT, minGram, maxGram);
    }

    private void init(Side side, int minGram, int maxGram) {
        if (side == null) {
            throw new IllegalArgumentException("sideLabel must be either front or back");
        }
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        maxGram = Math.min(maxGram, 1024);
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.side = side;
    }

    @Override
    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (!this.started) {
            this.started = true;
            this.gramSize = this.minGram;
            int limit = this.side == Side.FRONT ? this.maxGram : 1024;
            char[] chars = new char[Math.min(1024, limit)];
            this.charsRead = 0;
            boolean exhausted = false;
            while (this.charsRead < limit) {
                int inc = this.input.read(chars, this.charsRead, chars.length - this.charsRead);
                if (inc == -1) {
                    exhausted = true;
                    break;
                }
                this.charsRead += inc;
                if (this.charsRead != chars.length || this.charsRead >= limit) continue;
                chars = ArrayUtil.grow(chars);
            }
            this.inStr = new String(chars, 0, this.charsRead);
            this.inStr = this.inStr.trim();
            if (!exhausted) {
                int inc;
                char[] throwaway = new char[1024];
                while ((inc = this.input.read(throwaway, 0, throwaway.length)) != -1) {
                    this.charsRead += inc;
                }
            }
            this.inLen = this.inStr.length();
            if (this.inLen == 0) {
                return false;
            }
            this.posIncrAtt.setPositionIncrement(1);
        } else {
            this.posIncrAtt.setPositionIncrement(0);
        }
        if (this.gramSize > this.inLen) {
            return false;
        }
        if (this.gramSize > this.maxGram || this.gramSize > this.inLen) {
            return false;
        }
        int start2 = this.side == Side.FRONT ? 0 : this.inLen - this.gramSize;
        int end = start2 + this.gramSize;
        this.termAtt.setEmpty().append(this.inStr, start2, end);
        this.offsetAtt.setOffset(this.correctOffset(start2), this.correctOffset(end));
        ++this.gramSize;
        return true;
    }

    @Override
    public void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.charsRead);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.started = false;
    }

    public static enum Side {
        FRONT{

            @Override
            public String getLabel() {
                return "front";
            }
        }
        ,
        BACK{

            @Override
            public String getLabel() {
                return "back";
            }
        };


        public abstract String getLabel();

        public static Side getSide(String sideName) {
            if (FRONT.getLabel().equals(sideName)) {
                return FRONT;
            }
            if (BACK.getLabel().equals(sideName)) {
                return BACK;
            }
            return null;
        }
    }
}

