/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.th;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Locale;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.util.CharArrayIterator;
import org.apache.lucene.util.AttributeSource;

@Deprecated
public final class ThaiWordFilter
extends TokenFilter {
    public static final boolean DBBI_AVAILABLE = ThaiTokenizer.DBBI_AVAILABLE;
    private static final BreakIterator proto = BreakIterator.getWordInstance(new Locale("th"));
    private final BreakIterator breaker = (BreakIterator)proto.clone();
    private final CharArrayIterator charIterator = CharArrayIterator.newWordInstance();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posAtt = this.addAttribute(PositionIncrementAttribute.class);
    private AttributeSource clonedToken = null;
    private CharTermAttribute clonedTermAtt = null;
    private OffsetAttribute clonedOffsetAtt = null;
    private boolean hasMoreTokensInClone = false;
    private boolean hasIllegalOffsets = false;

    public ThaiWordFilter(TokenStream input) {
        super(input);
        if (!DBBI_AVAILABLE) {
            throw new UnsupportedOperationException("This JRE does not have support for Thai segmentation");
        }
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.hasMoreTokensInClone) {
            int start2 = this.breaker.current();
            int end = this.breaker.next();
            if (end != -1) {
                this.clonedToken.copyTo(this);
                this.termAtt.copyBuffer(this.clonedTermAtt.buffer(), start2, end - start2);
                if (this.hasIllegalOffsets) {
                    this.offsetAtt.setOffset(this.clonedOffsetAtt.startOffset(), this.clonedOffsetAtt.endOffset());
                } else {
                    this.offsetAtt.setOffset(this.clonedOffsetAtt.startOffset() + start2, this.clonedOffsetAtt.startOffset() + end);
                }
                this.posAtt.setPositionIncrement(1);
                return true;
            }
            this.hasMoreTokensInClone = false;
        }
        if (!this.input.incrementToken()) {
            return false;
        }
        if (this.termAtt.length() == 0 || Character.UnicodeBlock.of(this.termAtt.charAt(0)) != Character.UnicodeBlock.THAI) {
            return true;
        }
        this.hasMoreTokensInClone = true;
        boolean bl = this.hasIllegalOffsets = this.offsetAtt.endOffset() - this.offsetAtt.startOffset() != this.termAtt.length();
        if (this.clonedToken == null) {
            this.clonedToken = this.cloneAttributes();
            this.clonedTermAtt = this.clonedToken.getAttribute(CharTermAttribute.class);
            this.clonedOffsetAtt = this.clonedToken.getAttribute(OffsetAttribute.class);
        } else {
            this.copyTo(this.clonedToken);
        }
        this.charIterator.setText(this.clonedTermAtt.buffer(), 0, this.clonedTermAtt.length());
        this.breaker.setText(this.charIterator);
        int end = this.breaker.next();
        if (end != -1) {
            this.termAtt.setLength(end);
            if (this.hasIllegalOffsets) {
                this.offsetAtt.setOffset(this.clonedOffsetAtt.startOffset(), this.clonedOffsetAtt.endOffset());
            } else {
                this.offsetAtt.setOffset(this.clonedOffsetAtt.startOffset(), this.clonedOffsetAtt.startOffset() + end);
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.hasMoreTokensInClone = false;
        this.clonedToken = null;
        this.clonedTermAtt = null;
        this.clonedOffsetAtt = null;
    }
}

