/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import smile.clustering.PartitionClustering;
import smile.math.Math;
import smile.math.distance.Distance;
import smile.math.distance.Metric;
import smile.neighbor.CoverTree;
import smile.neighbor.LinearSearch;
import smile.neighbor.Neighbor;
import smile.neighbor.RNNSearch;

public class DBScan<T>
extends PartitionClustering<T> {
    private static final int UNCLASSIFIED = -1;
    private double minPts;
    private double radius;
    private RNNSearch<T, T> nns;

    public DBScan(T[] data, Distance<T> distance, int minPts, double radius) {
        this(data, new LinearSearch<T>(data, distance), minPts, radius);
    }

    public DBScan(T[] data, Metric<T> distance, int minPts, double radius) {
        this(data, new CoverTree<T>(data, distance), minPts, radius);
    }

    public DBScan(T[] data, RNNSearch<T, T> nns, int minPts, double radius) {
        int i;
        if (minPts < 1) {
            throw new IllegalArgumentException("Invalid minPts: " + minPts);
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        this.nns = nns;
        this.minPts = minPts;
        this.radius = radius;
        this.k = 0;
        int n = data.length;
        this.y = new int[n];
        Arrays.fill(this.y, -1);
        for (i = 0; i < data.length; ++i) {
            if (this.y[i] != -1) continue;
            ArrayList neighbors = new ArrayList();
            nns.range(data[i], radius, neighbors);
            if (neighbors.size() < minPts) {
                this.y[i] = Integer.MAX_VALUE;
                continue;
            }
            this.y[i] = this.k;
            for (int j = 0; j < neighbors.size(); ++j) {
                if (this.y[((Neighbor)neighbors.get((int)j)).index] == -1) {
                    this.y[((Neighbor)neighbors.get((int)j)).index] = this.k;
                    Neighbor neighbor = (Neighbor)neighbors.get(j);
                    ArrayList secondaryNeighbors = new ArrayList();
                    nns.range(neighbor.key, radius, secondaryNeighbors);
                    if (secondaryNeighbors.size() >= minPts) {
                        neighbors.addAll(secondaryNeighbors);
                    }
                }
                if (this.y[((Neighbor)neighbors.get((int)j)).index] != Integer.MAX_VALUE) continue;
                this.y[((Neighbor)neighbors.get((int)j)).index] = this.k;
            }
            ++this.k;
        }
        this.size = new int[this.k + 1];
        for (i = 0; i < n; ++i) {
            if (this.y[i] == Integer.MAX_VALUE) {
                int n2 = this.k;
                this.size[n2] = this.size[n2] + 1;
                continue;
            }
            int n3 = this.y[i];
            this.size[n3] = this.size[n3] + 1;
        }
    }

    public double getMinPts() {
        return this.minPts;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public int predict(T x) {
        ArrayList neighbors = new ArrayList();
        this.nns.range(x, this.radius, neighbors);
        if ((double)neighbors.size() < this.minPts) {
            return Integer.MAX_VALUE;
        }
        int[] label = new int[this.k + 1];
        for (Neighbor neighbor : neighbors) {
            int yi = this.y[neighbor.index];
            if (yi == Integer.MAX_VALUE) {
                yi = this.k;
            }
            int n = yi;
            label[n] = label[n] + 1;
        }
        int c = Math.whichMax(label);
        if (c == this.k) {
            c = Integer.MAX_VALUE;
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("DBScan clusters of %d data points:\n", this.y.length));
        for (int i = 0; i < this.k; ++i) {
            int r = (int)Math.round(1000.0 * (double)this.size[i] / (double)this.y.length);
            sb.append(String.format("%3d\t%5d (%2d.%1d%%)\n", i, this.size[i], r / 10, r % 10));
        }
        int r = (int)Math.round(1000.0 * (double)this.size[this.k] / (double)this.y.length);
        sb.append(String.format("Noise\t%5d (%2d.%1d%%)\n", this.size[this.k], r / 10, r % 10));
        return sb.toString();
    }
}

