/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import smile.clustering.Clustering;
import smile.clustering.HierarchicalClustering;
import smile.clustering.linkage.UPGMALinkage;
import smile.math.Math;
import smile.sort.HeapSelect;

public class GrowingNeuralGas
implements Clustering<double[]> {
    private final int d;
    private int n = 0;
    private int m;
    private double epsBest = 0.05;
    private double epsNeighbor = 6.0E-4;
    private int maxEdgeAge = 88;
    private int lambda = 300;
    private double alpha = 0.5;
    private double beta = 0.9995;
    private LinkedList<Node> nodes = new LinkedList();
    private int[] y;

    public GrowingNeuralGas(int d) {
        this.d = d;
    }

    public GrowingNeuralGas(int d, double epsBest, double epsNeighbor, int maxEdgeAge, int lambda, double alpha, double beta) {
        this.d = d;
        this.epsBest = epsBest;
        this.epsNeighbor = epsNeighbor;
        this.maxEdgeAge = maxEdgeAge;
        this.lambda = lambda;
        this.alpha = alpha;
        this.beta = beta;
    }

    public Neuron[] neurons() {
        HashMap<Integer, Neuron> hash = new HashMap<Integer, Neuron>();
        Neuron[] neurons = new Neuron[this.nodes.size()];
        int i = 0;
        for (Node node : this.nodes) {
            Neuron[] neighbors = new Neuron[node.edges.size()];
            neurons[i] = new Neuron(node.w, neighbors);
            hash.put(node.id, neurons[i]);
            ++i;
        }
        i = 0;
        for (Node node : this.nodes) {
            int j = 0;
            for (Edge edge : node.edges) {
                if (edge.a != node) {
                    neurons[i].neighbors[j++] = (Neuron)hash.get(edge.a.id);
                    continue;
                }
                neurons[i].neighbors[j++] = (Neuron)hash.get(edge.b.id);
            }
            ++i;
        }
        return neurons;
    }

    /*
     * WARNING - void declaration
     */
    public void update(double[] x) {
        ++this.n;
        if (this.nodes.size() < 2) {
            this.nodes.add(new Node((double[])x.clone()));
            return;
        }
        Comparable[] top2 = new Node[2];
        HeapSelect heap = new HeapSelect(top2);
        for (Node neuron : this.nodes) {
            neuron.dist = Math.squaredDistance(neuron.w, x);
            heap.add(neuron);
        }
        Comparable s1 = top2[1];
        Comparable s2 = top2[0];
        ((Node)s1).error += ((Node)s1).dist;
        for (int i = 0; i < this.d; ++i) {
            int n = i;
            ((Node)s1).w[n] = ((Node)s1).w[n] + this.epsBest * (x[i] - ((Node)s1).w[i]);
        }
        boolean addEdge = true;
        for (Edge edge : ((Node)s1).edges) {
            int i;
            if (edge.a != s1) {
                for (i = 0; i < this.d; ++i) {
                    int n = i;
                    edge.a.w[n] = edge.a.w[n] + this.epsNeighbor * (x[i] - edge.a.w[i]);
                }
            } else {
                for (i = 0; i < this.d; ++i) {
                    int n = i;
                    edge.b.w[n] = edge.b.w[n] + this.epsNeighbor * (x[i] - edge.b.w[i]);
                }
            }
            ++edge.age;
            if (edge.a != s2 && edge.b != s2) continue;
            edge.age = 0;
            addEdge = false;
        }
        if (addEdge) {
            Edge edge = new Edge((Node)s1, (Node)s2);
            ((Node)s1).edges.add(edge);
            ((Node)s2).edges.add(edge);
        }
        Iterator iter = ((Node)s1).edges.iterator();
        while (iter.hasNext()) {
            Edge edge = (Edge)iter.next();
            if (edge.age <= this.maxEdgeAge) continue;
            iter.remove();
            if (edge.a != s1) {
                edge.a.edges.remove(edge);
                if (edge.a.edges.size() != 0) continue;
                this.nodes.remove(edge.a);
                continue;
            }
            edge.b.edges.remove(edge);
            if (edge.b.edges.size() != 0) continue;
            this.nodes.remove(edge.b);
        }
        if (this.n % this.lambda == 0) {
            void var8_13;
            Node q = this.nodes.get(0);
            for (Node neuron : this.nodes) {
                if (!(neuron.error > q.error)) continue;
                q = neuron;
            }
            Object var8_12 = null;
            for (Edge edge : q.edges) {
                if (edge.a != q) {
                    if (var8_13 != null && !(edge.a.error > var8_13.error)) continue;
                    Node node = edge.a;
                    continue;
                }
                if (var8_13 != null && !(edge.b.error > var8_13.error)) continue;
                Node node = edge.b;
            }
            if (var8_13 != null) {
                double[] w = new double[this.d];
                for (int i = 0; i < this.d; ++i) {
                    int n = i;
                    w[n] = w[n] + (q.w[i] + var8_13.w[i]) / 2.0;
                }
                Node r = new Node(w);
                q.error *= this.alpha;
                var8_13.error *= this.alpha;
                r.error = q.error;
                this.nodes.add(r);
            }
        }
        for (Node node : this.nodes) {
            node.error *= this.beta;
        }
    }

    public void partition(int k) {
        double[][] reps = new double[this.nodes.size()][];
        int i = 0;
        for (Node neuron : this.nodes) {
            reps[i++] = neuron.w;
        }
        double[][] proximity = new double[this.nodes.size()][];
        for (i = 0; i < this.nodes.size(); ++i) {
            proximity[i] = new double[i + 1];
            for (int j = 0; j < i; ++j) {
                proximity[i][j] = Math.distance(reps[i], reps[j]);
            }
        }
        UPGMALinkage linkage = new UPGMALinkage(proximity);
        HierarchicalClustering hc = new HierarchicalClustering(linkage);
        this.y = hc.partition(k);
    }

    @Override
    public int predict(double[] x) {
        double minDist = Double.MAX_VALUE;
        int bestCluster = 0;
        int i = 0;
        for (Node neuron : this.nodes) {
            double dist = Math.squaredDistance(x, neuron.w);
            if (dist < minDist) {
                minDist = dist;
                bestCluster = i;
            }
            ++i;
        }
        if (this.y == null || this.y.length != this.nodes.size()) {
            return bestCluster;
        }
        return this.y[bestCluster];
    }

    class Node
    implements Comparable<Node> {
        int id;
        double[] w;
        double dist = Double.MAX_VALUE;
        double error = 0.0;
        LinkedList<Edge> edges;

        Node(double[] w) {
            this.w = w;
            this.edges = new LinkedList();
            this.id = GrowingNeuralGas.this.m++;
        }

        @Override
        public int compareTo(Node o) {
            return (int)Math.signum(this.dist - o.dist);
        }
    }

    class Edge {
        Node a;
        Node b;
        int age = 0;

        Edge(Node a, Node b) {
            this.a = a;
            this.b = b;
        }
    }

    public static class Neuron {
        public final double[] w;
        public final Neuron[] neighbors;

        public Neuron(double[] w, Neuron[] neighbors) {
            this.w = w;
            this.neighbors = neighbors;
        }
    }
}

