/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

import smile.clustering.linkage.Linkage;

public class UPGMALinkage
extends Linkage {
    private int[] n;

    public UPGMALinkage(double[][] proximity) {
        this.proximity = proximity;
        this.n = new int[proximity.length];
        for (int i = 0; i < this.n.length; ++i) {
            this.n[i] = 1;
        }
    }

    public String toString() {
        return "UPGMA linkage";
    }

    @Override
    public void merge(int i, int j) {
        int k;
        double sum = this.n[i] + this.n[j];
        for (k = 0; k < i; ++k) {
            this.proximity[i][k] = this.proximity[i][k] * (double)this.n[i] / sum + this.d(j, k) * (double)this.n[j] / sum;
        }
        for (k = i + 1; k < this.proximity.length; ++k) {
            this.proximity[k][i] = this.proximity[k][i] * (double)this.n[i] / sum + this.d(j, k) * (double)this.n[j] / sum;
        }
        int n = i;
        this.n[n] = this.n[n] + this.n[j];
    }
}

