/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

import smile.clustering.linkage.Linkage;

public class WPGMCLinkage
extends Linkage {
    public WPGMCLinkage(double[][] proximity) {
        this.proximity = proximity;
        for (int i = 0; i < proximity.length; ++i) {
            for (int j = 0; j < i; ++j) {
                double[] dArray = proximity[i];
                int n = j;
                dArray[n] = dArray[n] * proximity[i][j];
            }
        }
    }

    public String toString() {
        return "WPGMC linkage";
    }

    @Override
    public void merge(int i, int j) {
        int k;
        for (k = 0; k < i; ++k) {
            this.proximity[i][k] = (this.proximity[i][k] + this.proximity[j][k]) / 2.0 - this.proximity[j][i] / 4.0;
        }
        for (k = i + 1; k < j; ++k) {
            this.proximity[k][i] = (this.proximity[k][i] + this.proximity[j][k]) / 2.0 - this.proximity[j][i] / 4.0;
        }
        for (k = j + 1; k < this.proximity.length; ++k) {
            this.proximity[k][i] = (this.proximity[k][i] + this.proximity[k][j]) / 2.0 - this.proximity[j][i] / 4.0;
        }
    }
}

