/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.text.ParseException;

public abstract class Attribute {
    public final Type type;
    public final double weight;
    public final String name;
    public final String description;

    public Attribute(Type type, String name) {
        this(type, name, 1.0);
    }

    public Attribute(Type type, String name, double weight) {
        this(type, name, null, weight);
    }

    public Attribute(Type type, String name, String description) {
        this(type, name, description, 1.0);
    }

    public Attribute(Type type, String name, String description, double weight) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.weight = weight;
    }

    public abstract String toString(double var1);

    public abstract double valueOf(String var1) throws ParseException;

    public boolean equals(Object o) {
        if (o instanceof Attribute) {
            Attribute a = (Attribute)o;
            if (this.name.equals(a.name) && this.type == a.type) {
                return this.description != null && a.description != null && this.description.equals(a.description);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + this.type.hashCode();
        hash = 37 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 37 * hash + (this.description != null ? this.description.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.type);
        sb.append('[');
        sb.append(this.name);
        sb.append(']');
        return sb.toString();
    }

    public static enum Type {
        NUMERIC,
        NOMINAL,
        STRING,
        DATE;

    }
}

