/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import smile.data.Attribute;
import smile.data.Datum;

public class Dataset<E>
implements Iterable<Datum<E>> {
    private String name;
    private String description = "";
    private Attribute response = null;
    private List<Datum<E>> data = new ArrayList<Datum<E>>();

    public Dataset() {
        this("Dataset");
    }

    public Dataset(String name) {
        this.name = name;
    }

    public Dataset(Attribute response) {
        this("Dataset", response);
    }

    public Dataset(String name, Attribute response) {
        this.name = name;
        this.response = response;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Attribute response() {
        return this.response;
    }

    public int size() {
        return this.data.size();
    }

    public void add(Datum<E> x) {
        this.data.add(x);
    }

    public void add(E x) {
        this.add((E)new Datum<E>(x));
    }

    public void add(E x, int y) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.type != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException("The response variable is not nominal.");
        }
        this.add((E)new Datum<E>(x, y));
    }

    public void add(E x, int y, double weight) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.type != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException("The response variable is not nominal.");
        }
        this.add((E)new Datum<E>(x, y, weight));
    }

    public void add(E x, double y) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.type != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException("The response variable is not numeric.");
        }
        this.add((E)new Datum<E>(x, y));
    }

    public void add(E x, double y, double weight) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.type != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException("The response variable is not numeric.");
        }
        this.add((E)new Datum<E>(x, y, weight));
    }

    public Datum<E> remove(int i) {
        return this.data.remove(i);
    }

    public Datum<E> get(int i) {
        return this.data.get(i);
    }

    @Override
    public Iterator<Datum<E>> iterator() {
        return new Iterator<Datum<E>>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Dataset.this.data.size();
            }

            @Override
            public Datum<E> next() {
                return Dataset.this.get(this.i++);
            }

            @Override
            public void remove() {
                Dataset.this.remove(this.i);
            }
        };
    }

    public E[] toArray(E[] a) {
        int i;
        int n = this.data.size();
        if (a.length < n) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), n);
        }
        for (i = 0; i < n; ++i) {
            a[i] = this.get((int)i).x;
        }
        for (i = n; i < a.length; ++i) {
            a[i] = null;
        }
        return a;
    }

    public int[] toArray(int[] a) {
        int i;
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.type != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException("The response variable is not nominal.");
        }
        int n = this.data.size();
        if (a.length < n) {
            a = new int[n];
        }
        for (i = 0; i < n; ++i) {
            Datum<E> datum = this.get(i);
            a[i] = Double.isNaN(datum.y) ? Integer.MIN_VALUE : (int)this.get((int)i).y;
        }
        for (i = n; i < a.length; ++i) {
            a[i] = Integer.MIN_VALUE;
        }
        return a;
    }

    public double[] toArray(double[] a) {
        int i;
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.type != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException("The response variable is not numeric.");
        }
        int n = this.data.size();
        if (a.length < n) {
            a = new double[n];
        }
        for (i = 0; i < n; ++i) {
            a[i] = this.get((int)i).y;
        }
        for (i = n; i < a.length; ++i) {
            a[i] = Double.NaN;
        }
        return a;
    }

    public String[] toArray(String[] a) {
        int i;
        int n = this.data.size();
        if (a.length < n) {
            a = new String[n];
        }
        for (i = 0; i < n; ++i) {
            a[i] = this.data.get((int)i).name;
        }
        for (i = n; i < a.length; ++i) {
            a[i] = null;
        }
        return a;
    }

    public Timestamp[] toArray(Timestamp[] a) {
        int i;
        int n = this.data.size();
        if (a.length < n) {
            a = new Timestamp[n];
        }
        for (i = 0; i < n; ++i) {
            a[i] = this.data.get((int)i).timestamp;
        }
        for (i = n; i < a.length; ++i) {
            a[i] = null;
        }
        return a;
    }
}

