/*
 * Decompiled with CFR 0.152.
 */
package smile.data.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.Datum;
import smile.data.NominalAttribute;
import smile.data.NumericAttribute;
import smile.data.StringAttribute;

public class DelimitedTextParser {
    private String delimiter = "\\s+";
    private String comment = "%";
    private String missing = "?";
    private boolean hasColumnNames = false;
    private boolean hasRowNames = false;
    private Attribute response = null;
    private int responseIndex = -1;

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getCommentStartWith() {
        return this.comment;
    }

    public void setCommentStartWith(String comment) {
        this.comment = comment;
    }

    public String getMissingValuePlaceholder() {
        return this.missing;
    }

    public void setMissingValuePlaceholder(String missing) {
        this.missing = missing;
    }

    public void setResponseIndex(Attribute response, int index) {
        if (response.type != Attribute.Type.NOMINAL && response.type != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException("The response variable is not numeric or nominal.");
        }
        this.response = response;
        this.responseIndex = index;
    }

    public boolean hasRowNames() {
        return this.hasRowNames;
    }

    public void setRowNames(boolean hasRowNames) {
        this.hasRowNames = hasRowNames;
    }

    public boolean hasColumnNames() {
        return this.hasColumnNames;
    }

    public void setColumnNames(boolean hasColNames) {
        this.hasColumnNames = hasColNames;
    }

    public AttributeDataset parse(URI uri) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(uri));
    }

    public AttributeDataset parse(String name, Attribute[] attributes, URI uri) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, attributes, new File(uri));
    }

    public AttributeDataset parse(String path) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(path));
    }

    public AttributeDataset parse(String name, Attribute[] attributes, String path) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, attributes, new File(path));
    }

    public AttributeDataset parse(File file) throws FileNotFoundException, IOException, ParseException {
        String name = file.getPath();
        return this.parse(name, new FileInputStream(file));
    }

    public AttributeDataset parse(String name, Attribute[] attributes, File file) throws FileNotFoundException, IOException, ParseException {
        AttributeDataset data = new AttributeDataset(name, attributes, this.response);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            this.parse(data, reader);
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    public AttributeDataset parse(String name, InputStream stream) throws IOException, ParseException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            int i;
            String line = reader.readLine();
            while (line != null && (line.isEmpty() || line.startsWith(this.comment))) {
                line = reader.readLine();
            }
            if (line == null) {
                throw new IOException("Empty data source.");
            }
            String[] s = line.split(this.delimiter, 0);
            boolean start2 = false;
            int dimension = s.length;
            if (this.hasRowNames) {
                --dimension;
                start2 = true;
            }
            if (this.responseIndex >= s.length) {
                throw new ParseException("Invalid response variable index: " + this.responseIndex, this.responseIndex);
            }
            if (this.responseIndex >= 0) {
                --dimension;
            }
            Attribute[] attributes = new Attribute[dimension];
            if (this.hasColumnNames) {
                i = 0;
                boolean bl = start2;
                while (i < dimension) {
                    void var11_14;
                    if (var11_14 != this.responseIndex) {
                        attributes[i++] = new NumericAttribute(s[var11_14]);
                    } else {
                        switch (this.response.type) {
                            case NOMINAL: {
                                this.response = new NominalAttribute(s[var11_14]);
                                break;
                            }
                            case NUMERIC: {
                                this.response = new NumericAttribute(s[var11_14]);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Invalid response variable type.");
                            }
                        }
                    }
                    ++var11_14;
                }
            } else {
                for (i = 0; i < dimension; ++i) {
                    attributes[i] = new NumericAttribute("V" + (i + 1));
                }
            }
            AttributeDataset data = new AttributeDataset(name, attributes, this.response);
            if (!this.hasColumnNames) {
                String object = this.hasRowNames ? s[0] : null;
                double[] x = new double[attributes.length];
                double y = Double.NaN;
                int k = 0;
                for (int i2 = this.hasRowNames ? 1 : 0; i2 < s.length; ++i2) {
                    if (i2 == this.responseIndex) {
                        y = this.response.valueOf(s[i2]);
                        continue;
                    }
                    if (this.missing != null && this.missing.equalsIgnoreCase(s[i2])) {
                        x[k++] = Double.NaN;
                        continue;
                    }
                    x[k] = attributes[k].valueOf(s[i2]);
                    ++k;
                }
                Datum<double[]> datum = new Datum<double[]>(x, y);
                datum.name = object;
                data.add(datum);
            }
            this.parse(data, reader);
            for (Attribute attribute : attributes) {
                Attribute a;
                if (attribute instanceof NominalAttribute) {
                    a = (NominalAttribute)attribute;
                    ((NominalAttribute)a).setOpen(false);
                }
                if (!(attribute instanceof StringAttribute)) continue;
                a = (StringAttribute)attribute;
                ((StringAttribute)a).setOpen(false);
            }
            AttributeDataset attributeDataset = data;
            return attributeDataset;
        }
    }

    private void parse(AttributeDataset data, BufferedReader reader) throws IOException, ParseException {
        Attribute[] attributes = data.attributes();
        int n = attributes.length;
        if (this.hasRowNames) {
            ++n;
        }
        if (this.responseIndex >= 0) {
            ++n;
        }
        String line = null;
        boolean firstLine = true;
        while ((line = reader.readLine()) != null) {
            if (this.hasColumnNames && firstLine) {
                firstLine = false;
                continue;
            }
            if (line.isEmpty() || line.startsWith(this.comment)) continue;
            String[] s = line.split(this.delimiter, 0);
            if (s.length != n) {
                throw new ParseException(String.format("%d columns, expected %d", s.length, n), s.length);
            }
            String rowName = this.hasRowNames ? s[0] : null;
            double[] x = new double[attributes.length];
            double y = Double.NaN;
            int k = 0;
            for (int i = this.hasRowNames ? 1 : 0; i < s.length; ++i) {
                if (i == this.responseIndex) {
                    y = this.response.valueOf(s[i]);
                    continue;
                }
                if (this.missing != null && this.missing.equalsIgnoreCase(s[i])) {
                    x[k++] = Double.NaN;
                    continue;
                }
                x[k] = attributes[k].valueOf(s[i]);
                ++k;
            }
            Datum<double[]> datum = new Datum<double[]>(x, y);
            datum.name = rowName;
            data.add(datum);
        }
    }
}

