/*
 * Decompiled with CFR 0.152.
 */
package smile.data.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.Scanner;
import smile.math.matrix.SparseMatrix;

public class SparseMatrixParser {
    public SparseMatrix parse(URI uri) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(uri));
    }

    public SparseMatrix parse(String path) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(path));
    }

    public SparseMatrix parse(File file) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new FileInputStream(file));
    }

    public SparseMatrix parse(InputStream stream) throws IOException, ParseException {
        double[] data;
        int[] rowIndex;
        int[] colIndex;
        int nrows = 0;
        int ncols = 0;
        int n = 0;
        try (Scanner scanner = new Scanner(stream);){
            int i;
            String line = scanner.nextLine();
            String[] tokens = line.split("\\s+");
            if (tokens.length == 3) {
                try {
                    nrows = Integer.valueOf(tokens[0]);
                    ncols = Integer.valueOf(tokens[1]);
                    n = Integer.valueOf(tokens[2]);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (n == 0) {
                line = scanner.nextLine().trim();
                tokens = line.split("\\s+");
                int RHSCRD = Integer.valueOf(tokens[4]);
                line = scanner.nextLine().trim();
                if (!line.startsWith("R")) {
                    throw new UnsupportedOperationException("SparseMatrixParser supports only real-valued matrix.");
                }
                tokens = line.split("\\s+");
                nrows = Integer.valueOf(tokens[1]);
                ncols = Integer.valueOf(tokens[2]);
                n = Integer.valueOf(tokens[3]);
                line = scanner.nextLine();
                if (RHSCRD > 0) {
                    line = scanner.nextLine();
                }
            }
            colIndex = new int[ncols + 1];
            rowIndex = new int[n];
            data = new double[n];
            for (i = 0; i <= ncols; ++i) {
                colIndex[i] = scanner.nextInt() - 1;
            }
            for (i = 0; i < n; ++i) {
                rowIndex[i] = scanner.nextInt() - 1;
            }
            for (i = 0; i < n; ++i) {
                data[i] = scanner.nextDouble();
            }
        }
        SparseMatrix matrix = new SparseMatrix(nrows, ncols, data, rowIndex, colIndex);
        return matrix;
    }
}

