/*
 * Decompiled with CFR 0.152.
 */
package smile.data.parser.microarray;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.Datum;
import smile.data.NumericAttribute;

public class GCTParser {
    public AttributeDataset parse(URI uri) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(uri));
    }

    public AttributeDataset parse(String name, URI uri) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, new File(uri));
    }

    public AttributeDataset parse(String path) throws FileNotFoundException, IOException, ParseException {
        return this.parse(new File(path));
    }

    public AttributeDataset parse(String name, String path) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, new File(path));
    }

    public AttributeDataset parse(File file) throws FileNotFoundException, IOException, ParseException {
        return this.parse(file.getPath(), new FileInputStream(file));
    }

    public AttributeDataset parse(String name, File file) throws FileNotFoundException, IOException, ParseException {
        return this.parse(name, new FileInputStream(file));
    }

    public AttributeDataset parse(String name, InputStream stream) throws IOException, ParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Empty data source.");
        }
        if (!line.equals("#1.2")) {
            throw new IOException("Invalid version.");
        }
        line = reader.readLine();
        if (line == null) {
            throw new IOException("Premature end of file.");
        }
        String[] tokens = line.split("\t", -1);
        if (tokens.length != 2) {
            throw new IOException("Invalid data size inforamation.");
        }
        int n = Integer.valueOf(tokens[0]);
        int p = Integer.valueOf(tokens[1]);
        if (n <= 0 || p <= 0) {
            throw new IOException(String.format("Invalid data size %d x %d.", n, p));
        }
        Attribute[] attributes = new Attribute[p];
        line = reader.readLine();
        if (line == null) {
            throw new IOException("Premature end of file.");
        }
        tokens = line.split("\t", -1);
        if (tokens.length != p + 2) {
            throw new IOException("Invalid title header.");
        }
        for (int i = 0; i < p; ++i) {
            attributes[i] = new NumericAttribute(tokens[i + 2]);
        }
        AttributeDataset data = new AttributeDataset(name, attributes);
        for (int i = 0; i < n; ++i) {
            line = reader.readLine();
            if (line == null) {
                throw new IOException("Premature end of file.");
            }
            tokens = line.split("\t", -1);
            if (tokens.length != p + 2) {
                throw new IOException(String.format("Invalid number of elements of line %d: %d", i + 4, tokens.length));
            }
            double[] x = new double[p];
            for (int j = 0; j < p; ++j) {
                x[j] = tokens[j + 2].isEmpty() ? Double.NaN : Double.valueOf(tokens[j + 2]);
            }
            Datum<double[]> datum = new Datum<double[]>(x);
            datum.name = tokens[0];
            datum.description = tokens[1];
            data.add(datum);
        }
        reader.close();
        return data;
    }
}

