/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import java.util.Date;
import smile.data.Attribute;
import smile.data.DateAttribute;
import smile.data.NumericAttribute;
import smile.feature.Feature;

public class DateFeature
implements Feature<double[]> {
    private Attribute[] attributes;
    private Attribute[] features;
    private Type[] types;
    private int[] map;

    public DateFeature(Attribute[] attributes, Type[] types) {
        this.attributes = attributes;
        this.types = types;
        int p = 0;
        for (Attribute attribute : attributes) {
            if (!(attribute instanceof DateAttribute)) continue;
            p += types.length;
        }
        this.features = new Attribute[p];
        this.map = new int[p];
        int i = 0;
        for (int j = 0; j < attributes.length; ++j) {
            Attribute attribute = attributes[j];
            if (!(attribute instanceof DateAttribute)) continue;
            DateAttribute date = (DateAttribute)attribute;
            double weight = date.weight;
            String name = date.name;
            String description = date.description;
            int k = 0;
            while (k < types.length) {
                this.features[i] = new NumericAttribute(name + "_" + (Object)((Object)types[k]), description, weight);
                this.map[i] = j;
                ++k;
                ++i;
            }
        }
    }

    @Override
    public Attribute[] attributes() {
        return this.features;
    }

    @Override
    public double f(double[] object, int id) {
        if (object.length != this.attributes.length) {
            throw new IllegalArgumentException(String.format("Invalide object size %d, expected %d", object.length, this.attributes.length));
        }
        if (id < 0 || id >= this.features.length) {
            throw new IllegalArgumentException("Invalide feature id: " + id);
        }
        Date date = new Date(Double.doubleToLongBits(object[this.map[id]]));
        Type t = this.types[id % this.types.length];
        switch (t) {
            case YEAR: {
                return 1900 + date.getYear();
            }
            case MONTH: {
                return date.getMonth();
            }
            case DAY_OF_MONTH: {
                return date.getDate();
            }
            case DAY_OF_WEEK: {
                return date.getDay();
            }
            case HOURS: {
                return date.getHours();
            }
            case MINUTES: {
                return date.getMinutes();
            }
            case SECONDS: {
                return date.getSeconds();
            }
        }
        throw new IllegalStateException("Impossible to reach here.");
    }

    public static enum Type {
        YEAR,
        MONTH,
        DAY_OF_MONTH,
        DAY_OF_WEEK,
        HOURS,
        MINUTES,
        SECONDS;

    }
}

