/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.Dataset;
import smile.data.Datum;
import smile.feature.Feature;

public class FeatureSet<T> {
    List<Feature<T>> features = new ArrayList<Feature<T>>();
    List<Attribute> attributes = new ArrayList<Attribute>();

    public void add(Feature<T> feature) {
        this.features.add(feature);
        this.attributes.addAll(Arrays.asList(feature.attributes()));
    }

    public void remove(Feature<T> feature) {
        if (this.features.remove(feature)) {
            this.attributes.clear();
            for (Feature<T> f : this.features) {
                this.attributes.addAll(Arrays.asList(f.attributes()));
            }
        }
    }

    public Attribute[] attributes() {
        return this.attributes.toArray(new Attribute[this.attributes.size()]);
    }

    public double[] f(T datum) {
        int i = 0;
        double[] x = new double[this.attributes.size()];
        for (Feature<T> feature : this.features) {
            int k = feature.attributes().length;
            for (int j = 0; j < k; ++j) {
                x[i] = feature.f(datum, j);
                ++i;
            }
        }
        return x;
    }

    public double[][] f(T[] data) {
        int n = data.length;
        double[][] x = new double[n][];
        for (int i = 0; i < n; ++i) {
            x[i] = this.f(data[i]);
        }
        return x;
    }

    public AttributeDataset f(Dataset<T> data) {
        AttributeDataset dataset = new AttributeDataset(data.getName(), this.attributes(), data.response());
        dataset.setDescription(data.getDescription());
        for (int i = 0; i < data.size(); ++i) {
            Datum<T> datum = data.get(i);
            Datum<double[]> x = new Datum<double[]>(this.f(datum.x), datum.y, datum.weight);
            x.name = datum.name;
            x.description = datum.description;
            x.timestamp = datum.timestamp;
            dataset.add(x);
        }
        return dataset;
    }
}

